/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Credentials;
import sun.security.krb5.PrincipalName;

public class SecurityUtil {
    public static final Log LOG = LogFactory.getLog(SecurityUtil.class);
    public static final String HOSTNAME_PATTERN = "_HOST";

    private static KerberosTicket getTgtFromSubject() throws IOException {
        Subject current = Subject.getSubject(AccessController.getContext());
        if (current == null) {
            throw new IOException("Can't get TGT from current Subject, because it is null");
        }
        Set<KerberosTicket> tickets = current.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket t : tickets) {
            if (!SecurityUtil.isOriginalTGT(t.getServer().getName())) continue;
            return t;
        }
        throw new IOException("Failed to find TGT from current Subject");
    }

    protected static boolean isOriginalTGT(String name) {
        if (name == null) {
            return false;
        }
        String[] components = name.split("[/@]");
        return components.length == 3 && "krbtgt".equals(components[0]) && components[1].equals(components[2]);
    }

    public static void fetchServiceTicket(URL remoteHost) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String serviceName = "host/" + remoteHost.getHost();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching service ticket for host at: " + serviceName));
        }
        Credentials serviceCred = null;
        try {
            PrincipalName principal = new PrincipalName(serviceName, 3);
            serviceCred = Credentials.acquireServiceCreds(principal.toString(), Krb5Util.ticketToCreds(SecurityUtil.getTgtFromSubject()));
        }
        catch (Exception e) {
            throw new IOException("Can't get service ticket for: " + serviceName, e);
        }
        if (serviceCred == null) {
            throw new IOException("Can't get service ticket for " + serviceName);
        }
        Subject.getSubject(AccessController.getContext()).getPrivateCredentials().add(Krb5Util.credsToTicket(serviceCred));
    }

    public static String getServerPrincipal(String principalConfig, String hostname) throws IOException {
        if (principalConfig == null) {
            return null;
        }
        String[] components = principalConfig.split("[/@]");
        if (components.length != 3) {
            throw new IOException("Kerberos service principal name isn't configured properly (should have 3 parts): " + principalConfig);
        }
        if (components[1].equals(HOSTNAME_PATTERN)) {
            String fqdn = hostname;
            if (fqdn == null || fqdn.equals("") || fqdn.equals("0.0.0.0")) {
                fqdn = SecurityUtil.getLocalHostName();
            }
            return components[0] + "/" + fqdn + "@" + components[2];
        }
        return principalConfig;
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey) throws IOException {
        SecurityUtil.login(conf, keytabFileKey, userNameKey, SecurityUtil.getLocalHostName());
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal(principalConfig, hostname);
        UserGroupInformation.loginUserFromKeytab(principalName, keytabFilename);
    }

    public static String buildDTServiceName(URI uri, int defPort) {
        int port = uri.getPort();
        if (port == -1) {
            port = defPort;
        }
        StringBuffer sb = new StringBuffer();
        String host = uri.getHost();
        host = host != null ? NetUtils.normalizeHostName(host) : "";
        sb.append(host).append(":").append(port);
        return sb.toString();
    }

    public static AccessControlList getAdminAcls(Configuration conf, String configKey) {
        try {
            AccessControlList adminAcl = new AccessControlList(conf.get(configKey, " "));
            adminAcl.addUser(UserGroupInformation.getCurrentUser().getShortUserName());
            return adminAcl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

