% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchTwoDCOW.R
\name{batch_2DCOW}
\alias{batch_2DCOW}
\title{Two Dimensional COW in batch.}
\usage{
batch_2DCOW(chrom_names, mod_time, segments, max_warp)
}
\arguments{
\item{chrom_names}{The names of the chromatograms to be aligned,
the first chromatogram name will be considered as the 
reference chromatogram.}

\item{mod_time}{The modulation time of the experiment.}

\item{segments}{A two integer vector with number of segments
which the first and second dimension will be subdivided, respectively.}

\item{max_warp}{A two intger vector with the maximum warping parameter.
\emph{Name} to merge with the chromatograms.}
}
\description{
`batch_2DCOW` returns the aligned chromatogram in a named list slot.
The first chromatogram is considered as the reference.
}
\details{
This is an adaptation of bidimesional COW alignment, first implementated 
in MATLAB. This function takes a sample chromatogram to be aligned 
to the reference. The argument [segment] will be used to split the whole
chromatogram in n parts in the first and the second dimension respectevily.
The [max_warp] argument provides de maximum tolerace of the signal
transformation as well to the first and the second dimension.
}
\examples{

GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
GB09_fl <- system.file("extdata", "09GB.cdf", package = "RGCxGC")
chrom_nm <- c(GB08_fl, GB09_fl)
\donttest{
batch_alignment <- batch_2DCOW(chrom_nm, 5L, c(10, 40), c(1, 10))
}

}
