% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/unsampled.R
\name{list_unsampled_reports}
\alias{list_unsampled_reports}
\title{Lists unsampled reports which the user has access to}
\usage{
list_unsampled_reports(account.id, webproperty.id, profile.id,
  start.index = NULL, max.results = NULL, token)
}
\arguments{
\item{account.id}{integer or character. The account ID to retrieve unsampled reports for. Must be a specific account ID, ~all is not supported.}

\item{webproperty.id}{character. Web property ID to retrieve unsampled reports for. Must be a specific web property ID, ~all is not supported. Requires specified \code{account.id}.}

\item{profile.id}{ineger or character. View (Profile) ID to retrieve unsampled reports for. Must be a specific view (profile) ID, ~all is not supported. Requires specified \code{account.id} and \code{webproperty.id}.}

\item{start.index}{integer. An index of the first unsampled report to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of unsampled reports to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An unsampled report collection lists Analytics unsampled reports to which the user has access. Each view (profile) can have a set of unsampled reports. Each resource in the unsampled report collection corresponds to a single Analytics unsampled report.
\item{id}{Unsampled report ID.}
\item{title}{Title of the unsampled report.}
\item{account.id}{Account ID to which this unsampled report belongs.}
\item{webproperty.id}{Web property ID to which this unsampled report belongs. The web property ID is of the form UA-XXXXX-YY.}
\item{profile.id}{View (Profile) ID to which this unsampled report belongs.}
\item{start-date}{The start date for the unsampled report.}
\item{end-date}{The end date for the unsampled report.}
\item{metrics}{The metrics for the unsampled report.}
\item{dimensions}{The dimensions for the unsampled report.}
\item{filters}{The filters for the unsampled report.}
\item{segment}{The segment for the unsampled report.}
\item{status}{Status of this unsampled report. Possible values are PENDING, COMPLETED, or FAILED.}
\item{download.type}{The type of download you need to use for the report data file.}
\item{created}{Time this unsampled report was created.}
\item{updated}{Time this unsampled report was last modified.}
}
\description{
Lists unsampled reports which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/unsampledReports}{Management API - Unsampled Reports}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_upload}}; \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_uploads}};
  \code{\link{list_webproperties}}
}

