% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get-mgmt.R
\name{get_goal}
\alias{get_goal}
\title{Gets a goal to which the user has access to}
\usage{
get_goal(account.id, webproperty.id, profile.id, goal.id, token,
  verbose = getOption("rga.verbose"))
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve the goal for.}

\item{webproperty.id}{character. Web property ID to retrieve the goal for.}

\item{profile.id}{ineger or character. View (Profile) ID to retrieve the goal for.}

\item{goal.id}{ineger or character. Goal ID to retrieve the goal for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
An Analytics goal resource
\item{id}{Goal ID.}
\item{kind}{Resource type for an Analytics goal.}
\item{selfLink}{Link for this goal.}
\item{accountId}{Account ID to which this goal belongs.}
\item{webPropertyId}{Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.}
\item{internalWebPropertyId}{Internal ID for the web property to which this goal belongs.}
\item{profileId}{View (Profile) ID to which this goal belongs.}
\item{name}{Goal name.}
\item{value}{Goal value.}
\item{active}{Determines whether this goal is active.}
\item{type}{Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, and EVENT.}
\item{created}{Time this goal was created.}
\item{updated}{Time this goal was last modified.}
\item{parentLink}{Parent link for a goal. Points to the view (profile) to which this goal belongs.}
\item{visitTimeOnSiteDetails}{Details for the goal of the type VISIT_TIME_ON_SITE.}
}
\description{
Gets a goal to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/goals}{Google Management API - Goals}
}
\seealso{
\code{\link{authorize}}

Other The Google Analytics Management API: \code{\link{get_accounts}},
  \code{\link{list_accounts}}; \code{\link{get_goals}},
  \code{\link{list_goals}}; \code{\link{get_profiles}},
  \code{\link{list_profiles}}; \code{\link{get_profile}};
  \code{\link{get_segments}}, \code{\link{list_segments}};
  \code{\link{get_webproperties}},
  \code{\link{list_webproperties}};
  \code{\link{get_webproperty}}
}

