% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_webproperties}
\alias{get_webproperties}
\title{Lists web properties which the user has access to}
\usage{
get_webproperties(account.id = "~all", start.index = NULL,
  max.results = NULL, token, verbose = getOption("rga.verbose", FALSE))
}
\arguments{
\item{account.id}{character. Account ID to retrieve web properties for. Can either be a specific account ID or "~all", which refers to all the accounts that user has access to.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of web properties to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame with Google Analytics management data.
\item{accountId}{Account ID to which this web property belongs.}
\item{id}{web property ID of the form UA-XXXXX-YY.}
\item{name}{name of this web property.}
\item{websiteUrl}{website url for this web property.}
\item{level}{level for this web property. Acceptable values are: "PREMIUM", "STANDARD".}
\item{industryVertical}{we propetry industry vertical category.}
\item{profileCount}{view (Profile) count for this web property.}
\item{created}{time this web property was created.}
\item{updated}{time this web property was last modified.}
}
\description{
Lists web properties which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/webproperties}{Google Management API - Web Properties}
}
\seealso{
\code{\link{authorize}}

Other The.Google.Analytics.Management.API: \code{\link{get_accounts}};
  \code{\link{get_goals}}; \code{\link{get_profiles}};
  \code{\link{get_segments}}
}

