/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class DefaultGraphModel
extends UndoableEditSupport
implements Serializable,
GraphModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = new ArrayList();
    protected boolean asksAllowsChildren = false;
    static /* synthetic */ Class class$org$jgraph$event$GraphModelListener;

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int n) {
        return this.roots.get(n);
    }

    public int getIndexOfRoot(Object object) {
        return this.roots.indexOf(object);
    }

    public boolean contains(Object object) {
        Object object2 = null;
        while ((object2 = this.getParent(object)) != null) {
            object = object2;
        }
        return this.roots.contains(object);
    }

    public Map getAttributes(Object object) {
        if (object instanceof GraphCell) {
            return ((GraphCell)object).getAttributes();
        }
        return null;
    }

    public Object getSource(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getSource();
        }
        return null;
    }

    public Object getTarget(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getTarget();
        }
        return null;
    }

    public boolean acceptsSource(Object object, Object object2) {
        return true;
    }

    public boolean acceptsTarget(Object object, Object object2) {
        return true;
    }

    public Iterator edges(Object object) {
        if (object instanceof Port) {
            return ((Port)object).edges();
        }
        return this.emptyIterator;
    }

    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    public boolean isPort(Object object) {
        return object instanceof Port;
    }

    public Map cloneCells(Object[] objectArray) {
        GraphCell graphCell;
        Iterator<Object> iterator;
        Hashtable<GraphCell, DefaultGraphCell> hashtable = new Hashtable<GraphCell, DefaultGraphCell>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        while (!arrayList.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            iterator = arrayList.remove(0);
            if (!(iterator instanceof DefaultGraphCell)) continue;
            int n2 = 0;
            while (n2 < this.getChildCount(iterator)) {
                arrayList.add(this.getChild(iterator, n2));
                ++n2;
            }
            graphCell = (DefaultGraphCell)((Object)iterator);
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)((DefaultGraphCell)graphCell).clone();
            Object object = this.getParent(graphCell);
            if (object != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)hashtable.get(object)) != null) {
                defaultMutableTreeNode.add(defaultGraphCell);
            }
            hashtable.put(graphCell, defaultGraphCell);
        }
        iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Port) || (graphCell = ((Port)object).getAnchor()) == null) continue;
            ((Port)object).setAnchor((Port)hashtable.get(graphCell));
        }
        return hashtable;
    }

    public Object getParent(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getParent();
        }
        return null;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    public Object getChild(Object object, int n) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildAt(n);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        if (this.asksAllowsChildren && object instanceof TreeNode) {
            return !((TreeNode)object).getAllowsChildren();
        }
        return ((TreeNode)object).isLeaf();
    }

    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = this.createInsertEdit(objectArray, map, connectionSet, parentMap, undoableEditArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            if (undoableEditArray != null) {
                int n = 0;
                while (n < undoableEditArray.length) {
                    if (undoableEditArray[n] instanceof GraphModelEvent.ExecutableGraphChange) {
                        ((GraphModelEvent.ExecutableGraphChange)((Object)undoableEditArray[n])).execute();
                    }
                    ++n;
                }
            }
            this.postEdit(graphModelEdit);
        }
    }

    public void remove(Object[] objectArray) {
        GraphModelEdit graphModelEdit = this.createRemoveEdit(objectArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            this.postEdit(graphModelEdit);
        }
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        if ((map == null || map.isEmpty()) && (connectionSet == null || connectionSet.isEmpty()) && parentMap == null && undoableEditArray != null && undoableEditArray.length == 1) {
            if (undoableEditArray[0] instanceof GraphModelEvent.ExecutableGraphChange) {
                ((GraphModelEvent.ExecutableGraphChange)((Object)undoableEditArray[0])).execute();
            }
            this.postEdit(undoableEditArray[0]);
        } else {
            GraphModelEdit graphModelEdit = this.createCellEdit(map, connectionSet, parentMap, undoableEditArray);
            if (graphModelEdit != null) {
                graphModelEdit.execute();
                if (undoableEditArray != null) {
                    int n = 0;
                    while (n < undoableEditArray.length) {
                        if (undoableEditArray[n] instanceof GraphModelEvent.ExecutableGraphChange) {
                            ((GraphModelEvent.ExecutableGraphChange)((Object)undoableEditArray[n])).execute();
                        }
                        ++n;
                    }
                }
                this.postEdit(graphModelEdit);
            }
        }
    }

    public void toBack(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = this.createLayerEdit(objectArray, -2);
        if (graphModelLayerEdit != null) {
            graphModelLayerEdit.execute();
            this.postEdit(graphModelLayerEdit);
        }
    }

    public void toFront(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = this.createLayerEdit(objectArray, -1);
        if (graphModelLayerEdit != null) {
            graphModelLayerEdit.execute();
            this.postEdit(graphModelLayerEdit);
        }
    }

    protected GraphModelLayerEdit createLayerEdit(Object[] objectArray, int n) {
        return new GraphModelLayerEdit(objectArray, n);
    }

    protected GraphModelEdit createInsertEdit(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = this.createEdit(objectArray, null, map, connectionSet, parentMap);
        if (graphModelEdit != null) {
            if (undoableEditArray != null) {
                int n = 0;
                while (n < undoableEditArray.length) {
                    graphModelEdit.addEdit(undoableEditArray[n]);
                    ++n;
                }
            }
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createRemoveEdit(Object[] objectArray) {
        ParentMap parentMap;
        ConnectionSet connectionSet = ConnectionSet.create(this, objectArray, true);
        GraphModelEdit graphModelEdit = this.createEdit(null, objectArray, null, connectionSet, parentMap = ParentMap.create(this, objectArray, true, false));
        if (graphModelEdit != null) {
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createCellEdit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = this.createEdit(null, null, map, connectionSet, parentMap);
        if (graphModelEdit != null) {
            if (undoableEditArray != null) {
                int n = 0;
                while (n < undoableEditArray.length) {
                    graphModelEdit.addEdit(undoableEditArray[n]);
                    ++n;
                }
            }
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createEdit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
        return new GraphModelEdit(objectArray, objectArray2, map, connectionSet, parentMap);
    }

    protected Object[] handleInsert(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (this.getParent(objectArray[n]) == null) {
                    this.roots.add(objectArray[n]);
                }
                ++n;
            }
            objectArray2 = DefaultGraphModel.getDescendants(this, objectArray).toArray();
        }
        return objectArray2;
    }

    protected Object[] handleRemove(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (this.getParent(objectArray[n]) == null && this.roots.remove(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap parentMap2 = new ParentMap();
            Iterator iterator = parentMap.entries();
            while (iterator.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                Object object = entry.getChild();
                Object object2 = entry.getParent();
                parentMap2.addEntry(object, this.getParent(object));
                if (object2 == null) {
                    if (object instanceof MutableTreeNode) {
                        ((MutableTreeNode)object).removeFromParent();
                    }
                } else if (object2 instanceof DefaultMutableTreeNode && object instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object);
                }
                boolean bl = this.roots.contains(object);
                if (object2 == null && !bl) {
                    this.roots.add(object);
                    continue;
                }
                if (object2 == null || !bl) continue;
                this.roots.remove(object);
            }
            return parentMap2;
        }
        return null;
    }

    protected Map handleAttributes(Map map) {
        if (map != null) {
            Hashtable hashtable = new Hashtable();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map2;
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Map map3 = (Map)entry.getValue();
                if (k instanceof GraphCell) {
                    map2 = ((GraphCell)k).changeAttributes(map3);
                    hashtable.put(k, map2);
                    continue;
                }
                map2 = this.getAttributes(k);
                if (map2 == null) continue;
                Map map4 = GraphConstants.applyMap(map3, map2);
                hashtable.put(k, map4);
            }
            return hashtable;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet connectionSet) {
        if (connectionSet != null) {
            ConnectionSet connectionSet2 = new ConnectionSet();
            Iterator iterator = connectionSet.connections();
            while (iterator.hasNext()) {
                ConnectionSet.Connection connection = (ConnectionSet.Connection)iterator.next();
                Object object = connection.getEdge();
                if (connection.isSource()) {
                    connectionSet2.connect(object, this.getSource(object), true);
                } else {
                    connectionSet2.connect(object, this.getTarget(object), false);
                }
                this.handleConnection(connection);
            }
            return connectionSet2;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection connection) {
        Object object = connection.getEdge();
        Object object2 = connection.isSource() ? this.getSource(object) : this.getTarget(object);
        Object object3 = connection.getPort();
        if (object3 != object2) {
            this.connect(object, object2, connection.isSource(), true);
            if (this.contains(object3) && this.contains(object)) {
                this.connect(object, object3, connection.isSource(), false);
            }
        }
    }

    protected void connect(Object object, Object object2, boolean bl, boolean bl2) {
        if (object2 instanceof Port) {
            if (bl2) {
                ((Port)object2).removeEdge(object);
            } else {
                ((Port)object2).addEdge(object);
            }
        }
        if (bl2) {
            object2 = null;
        }
        if (object instanceof Edge) {
            if (bl) {
                ((Edge)object).setSource(object2);
            } else {
                ((Edge)object).setTarget(object2);
            }
        }
    }

    public void addGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.add(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, graphModelListener);
    }

    public void removeGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, graphModelListener);
    }

    protected void fireGraphChanged(Object object, GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = this.listenerList.getListenerList();
        GraphModelEvent graphModelEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$jgraph$event$GraphModelListener == null ? DefaultGraphModel.class$("org.jgraph.event.GraphModelListener") : class$org$jgraph$event$GraphModelListener)) {
                if (graphModelEvent == null) {
                    graphModelEvent = new GraphModelEvent(object, graphModelChange);
                }
                ((GraphModelListener)objectArray[n + 1]).graphChanged(graphModelEvent);
            }
            n -= 2;
        }
    }

    public GraphModelListener[] getGraphModelListeners() {
        return (GraphModelListener[])this.listenerList.getListeners(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener);
    }

    public static Object getSourceVertex(GraphModel graphModel, Object object) {
        if (graphModel != null) {
            return graphModel.getParent(graphModel.getSource(object));
        }
        return null;
    }

    public static Object getTargetVertex(GraphModel graphModel, Object object) {
        if (graphModel != null) {
            return graphModel.getParent(graphModel.getTarget(object));
        }
        return null;
    }

    public static Object[] getRoots(GraphModel graphModel) {
        Object[] objectArray = null;
        if (graphModel != null) {
            objectArray = new Object[graphModel.getRootCount()];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = graphModel.getRootAt(n);
                ++n;
            }
        }
        return objectArray;
    }

    public static Set getEdges(GraphModel graphModel, Object[] objectArray) {
        HashSet hashSet = new HashSet();
        Set set = DefaultGraphModel.getDescendants(graphModel, objectArray);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = graphModel.edges(iterator.next());
                while (iterator2.hasNext()) {
                    hashSet.add(iterator2.next());
                }
            }
            hashSet.removeAll(set);
        }
        return hashSet;
    }

    public static Set getDescendants(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            Stack<Object> stack = new Stack<Object>();
            int n = 0;
            while (n < objectArray.length) {
                stack.add(objectArray[n]);
                ++n;
            }
            HashSet hashSet = new HashSet();
            while (!stack.isEmpty()) {
                Object e = stack.pop();
                int n2 = 0;
                while (n2 < graphModel.getChildCount(e)) {
                    stack.add(graphModel.getChild(e, n2));
                    ++n2;
                }
                if (e == null) continue;
                hashSet.add(e);
            }
            return hashSet;
        }
        return null;
    }

    public static List getDescendantList(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            Stack<Object> stack = new Stack<Object>();
            int n = objectArray.length - 1;
            while (n >= 0) {
                stack.add(objectArray[n]);
                --n;
            }
            LinkedList linkedList = new LinkedList();
            while (!stack.isEmpty()) {
                Object e = stack.pop();
                int n2 = graphModel.getChildCount(e) - 1;
                while (n2 >= 0) {
                    stack.add(graphModel.getChild(e, n2));
                    --n2;
                }
                if (e == null) continue;
                linkedList.add(e);
            }
            return linkedList;
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    public class GraphModelLayerEdit
    extends GraphLayoutCache.GraphViewLayerEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] parents;

        public GraphModelLayerEdit(Object[] objectArray, int n) {
            super(DefaultGraphModel.this, objectArray, n);
            HashSet<TreeNode> hashSet = new HashSet<TreeNode>();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof TreeNode) {
                    hashSet.add(((TreeNode)objectArray[n2]).getParent());
                }
                ++n2;
            }
            this.parents = hashSet.toArray();
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.parents;
        }

        public Object[] getInserted() {
            return null;
        }

        public Object[] getRemoved() {
            return null;
        }

        public Map getPreviousAttributes() {
            return null;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        public ParentMap getPreviousParentMap() {
            return null;
        }

        public void addImplicitEdit(UndoableEdit undoableEdit) {
        }

        public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
            return null;
        }

        public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
        }

        protected void updateListeners() {
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        protected List getParentList(Object object) {
            List list = null;
            if (object instanceof DefaultMutableTreeNode) {
                TreeNode treeNode = ((DefaultMutableTreeNode)object).getParent();
                list = treeNode instanceof DefaultGraphCell ? ((DefaultGraphCell)treeNode).getChildren() : DefaultGraphModel.this.roots;
            }
            return list;
        }
    }

    public class GraphModelEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphModelChange,
    GraphModelEvent.ExecutableGraphChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();

        public GraphModelEdit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
            this.insert = objectArray;
            this.remove = objectArray2;
            this.connectionSet = connectionSet;
            this.attributes = map;
            this.parentMap = parentMap;
            this.previousAttributes = map;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                Hashtable hashtable = new Hashtable();
                Iterator iterator = parentMap.entries();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                    Object object3 = entry.getChild();
                    if (DefaultGraphModel.this.isPort(object3) || (object2 = DefaultGraphModel.this.getParent(object3)) == (object = entry.getParent())) continue;
                    this.changeChildCount(hashtable, object2, -1);
                    this.changeChildCount(hashtable, object, 1);
                }
                this.handleEmptyGroups(this.filterParents(hashtable, 0));
            }
        }

        public Object[] filterParents(Map map, int n) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != n) continue;
                arrayList.add(entry.getKey());
            }
            return arrayList.toArray();
        }

        protected void changeChildCount(Map map, Object object, int n) {
            if (object != null) {
                Integer n2 = (Integer)map.get(object);
                if (n2 == null) {
                    n2 = new Integer(DefaultGraphModel.this.getChildCount(object));
                }
                int n3 = n2 + n;
                map.put(object, new Integer(n3));
            }
        }

        protected void handleEmptyGroups(Object[] objectArray) {
            if (objectArray != null && objectArray.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] objectArray2 = new Object[this.remove.length + objectArray.length];
                System.arraycopy(this.remove, 0, objectArray2, 0, this.remove.length);
                System.arraycopy(objectArray, 0, objectArray2, this.remove.length, objectArray.length);
                this.remove = objectArray2;
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Object[] getInserted() {
            return this.inserted;
        }

        public Object[] getRemoved() {
            return this.removed;
        }

        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        public ParentMap getParentMap() {
            return this.parentMap;
        }

        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            HashSet hashSet = new HashSet();
            if (this.attributes != null) {
                hashSet.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                hashSet.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                int n = 0;
                while (n < this.remove.length) {
                    hashSet.remove(this.remove[n]);
                    ++n;
                }
            }
            this.changed = hashSet.toArray();
            Set set = DefaultGraphModel.getEdges(DefaultGraphModel.this, this.changed);
            this.context = set.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultGraphModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = DefaultGraphModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = DefaultGraphModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultGraphModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = DefaultGraphModel.this.handleAttributes(this.attributes);
            this.changed = hashSet.toArray();
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
            if (graphLayoutCache != null && cellViewArray != null) {
                this.cellViews.put(graphLayoutCache, cellViewArray);
            }
        }

        public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
            return (CellView[])this.cellViews.get(graphLayoutCache);
        }

        public String toString() {
            int n;
            String string = new String();
            if (this.inserted != null) {
                string = string + "Inserted:\n";
                n = 0;
                while (n < this.inserted.length) {
                    string = string + "  " + this.inserted[n] + "\n";
                    ++n;
                }
            } else {
                string = string + "None inserted\n";
            }
            if (this.removed != null) {
                string = string + "Removed:\n";
                n = 0;
                while (n < this.removed.length) {
                    string = string + "  " + this.removed[n] + "\n";
                    ++n;
                }
            } else {
                string = string + "None removed\n";
            }
            if (this.changed != null && this.changed.length > 0) {
                string = string + "Changed:\n";
                n = 0;
                while (n < this.changed.length) {
                    string = string + "  " + this.changed[n] + "\n";
                    ++n;
                }
            } else {
                string = string + "None changed\n";
            }
            string = this.parentMap != null ? string + this.parentMap.toString() : string + "No parent map\n";
            return string;
        }
    }
}

