/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import cern.jet.random.engine.MersenneTwister;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.inspector.Inspector;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.population.Genotype;
import freak.core.searchspace.AbstractSearchSpace;
import freak.core.searchspace.HasMetric;
import freak.module.searchspace.GraphEdgeSelectionConfiguration;
import freak.module.searchspace.GraphEdgeSelectionConfigurationPanel;
import freak.module.searchspace.GraphEdgeSelectionGenotype;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class GraphEdgeSelection
extends AbstractSearchSpace
implements Configurable,
RunEventListener,
BatchEventListener,
HasMetric {
    protected int numOfVertices = 10;
    protected int numOfEdges = 15;
    protected int maxWeight = 100;
    protected double probForEdge = 0.5;
    protected int verticesInTriangles = 5;
    protected int verticesLolli = 5;
    protected int degreeK = 2;
    protected boolean keepGraphDuringBatch = true;
    protected String[] initTypes = new String[]{"Random with Fixed Edge Number", "Random with Fixed Edge Probability", "Random with Fixed Edge Probability and binary valued weights", "Full Graph", "Ingo's Graph", "Full Star-Graph", "Path", "Random Tree", "Lollipop Tree", "k-Tree", "Trap Line"};
    protected int initTypeChoice = 0;
    protected static final int RANDOM_FIXED_EDGES = 0;
    protected static final int RANDOM_FIXED_PROBABILITY = 1;
    protected static final int RANDOM_BINARY_VALUE = 2;
    protected static final int FULL = 3;
    protected static final int INGOS_GRAPH = 4;
    protected static final int STAR = 5;
    protected static final int PATH = 6;
    protected static final int TREE = 7;
    protected static final int LOLLI = 8;
    protected static final int K_TREE = 9;
    protected static final int SEMI = 10;
    protected static final int SEMI_P = 11;
    protected static final int TRAP_LINE = 12;
    protected Graph graph;
    protected boolean useInternalRNG = false;
    protected static MersenneTwister internalRNG = new MersenneTwister(12345);
    protected int internalRNGSeed = 12345;

    protected RandomElement getRandomElement() {
        if (this.useInternalRNG) {
            return internalRNG;
        }
        return this.schedule.getRandomElement();
    }

    public GraphEdgeSelection(Schedule schedule) {
        super(schedule);
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    public Genotype getRandomGenotype() {
        GraphEdgeSelectionGenotype g = new GraphEdgeSelectionGenotype(this.graph);
        RandomElement rand = this.getRandomElement();
        int i = 0;
        while (i < this.graph.getNumberOfEdges()) {
            g.getEdgeSelection()[i] = rand.choose(2) == 1;
            ++i;
        }
        return g;
    }

    public double getDistance(Genotype gt1, Genotype gt2) {
        boolean[] b1 = ((GraphEdgeSelectionGenotype)gt1).edgeSelection;
        boolean[] b2 = ((GraphEdgeSelectionGenotype)gt2).edgeSelection;
        int distance = 0;
        int i = 0;
        while (i < b1.length) {
            if (b1[i] != b2[i]) {
                ++distance;
            }
            ++i;
        }
        return distance;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public int getDimension() {
        if (this.initTypeChoice == 0) {
            return this.numOfEdges;
        }
        if (this.initTypeChoice == 4) {
            int triangles = (this.verticesInTriangles - 1) / 2;
            int nodesInClique = this.numOfVertices - this.verticesInTriangles;
            return triangles * 3 + nodesInClique * (nodesInClique - 1);
        }
        if (this.graph != null) {
            return this.graph.numberOfEdges;
        }
        throw new IllegalStateException("Dimension currently undetermined");
    }

    public double getSize() {
        return Math.pow(2.0, this.numOfEdges);
    }

    public String getName() {
        return "Graph Edge Selection";
    }

    public String getDescription() {
        return "The set of all possible edge selections of a specific weighted graph";
    }

    public Integer getPropertyNumberOfVertices() {
        return new Integer(this.numOfVertices);
    }

    public void setPropertyNumberOfVertices(Integer vertices) {
        this.numOfVertices = vertices;
        if (this.initTypeChoice == 3 || this.initTypeChoice == 5) {
            this.numOfEdges = this.numOfVertices * (this.numOfVertices - 1) / 2;
        }
    }

    public Integer getPropertyNumberOfEdges() {
        return new Integer(this.numOfEdges);
    }

    public void setPropertyNumberOfEdges(Integer edges) {
        this.numOfEdges = edges;
    }

    public Integer getPropertyVerticesLolli() {
        return new Integer(this.verticesLolli);
    }

    public void setPropertyVerticesLolli(Integer vert) {
        this.verticesLolli = vert;
    }

    public Integer getPropertyDegreeK() {
        return new Integer(this.degreeK);
    }

    public void setPropertyDegreeK(Integer k) {
        this.degreeK = k;
    }

    public Integer getPropertyMaximalWeight() {
        return new Integer(this.maxWeight);
    }

    public void setPropertyMaximalWeight(Integer maxWeight) {
        this.maxWeight = maxWeight;
    }

    public Double getPropertyProbabilityForEdge() {
        return new Double(this.probForEdge);
    }

    public void setPropertyProbabilityForEdge(Double prob) {
        this.probForEdge = prob;
    }

    public Integer getPropertyVerticesInTriangles() {
        return new Integer(this.verticesInTriangles);
    }

    public void setPropertyVerticesInTriangles(Integer vertices) {
        this.verticesInTriangles = vertices;
    }

    public StringArrayWrapper getPropertyInitializationType() {
        return new StringArrayWrapper(this.initTypes, this.initTypeChoice);
    }

    public synchronized void setPropertyInitializationType(StringArrayWrapper wrapper) {
        this.initTypeChoice = wrapper.getIndex();
        if (this.initTypeChoice == 3 || this.initTypeChoice == 5) {
            this.numOfEdges = this.numOfVertices * (this.numOfVertices - 1) / 2;
        }
    }

    public Boolean getPropertyKeepGraphDuringBatch() {
        return new Boolean(this.keepGraphDuringBatch);
    }

    public void setPropertyKeepGraphDuringBatch(Boolean value) {
        this.keepGraphDuringBatch = value;
    }

    public Boolean getPropertyUseInternalRNG() {
        return new Boolean(this.useInternalRNG);
    }

    public void setPropertyUseInternalRNG(Boolean value) {
        this.useInternalRNG = value;
    }

    public String getLongDescriptionForUseInternalRNG() {
        return "If this property is set to true, a Random Number Generator internal to this searchspace with a configurable random seed is used during initialization of random graphs. This is useful when one wants to run different algorithms on the same randomly generatedgraphs. If this property is set to false (default), the normalRNG of freak is used.";
    }

    public String getShortDescriptionForUseInternalRNG() {
        return "use internal RNG";
    }

    public Integer getPropertyInternalRNGSeed() {
        return new Integer(this.internalRNGSeed);
    }

    public void setPropertyInternalRNGSeed(Integer value) {
        this.internalRNGSeed = value;
        internalRNG = new MersenneTwister(this.internalRNGSeed);
    }

    public String getShortDescriptionForInternalRNGSeed() {
        return "internal RNG seed";
    }

    public String getLongDescriptionForInternalRNGSeed() {
        return "The random seed used for the internal RNG";
    }

    public void batchStarted(BatchEvent evt) {
        if (this.keepGraphDuringBatch) {
            this.initNewGraph();
        }
    }

    public void runStarted(RunEvent evt) {
        if (!this.keepGraphDuringBatch) {
            this.initNewGraph();
        }
    }

    public void initNewGraph() {
        switch (this.initTypeChoice) {
            case 4: {
                this.initIngosGraph();
                this.postInit();
                break;
            }
            case 0: {
                do {
                    this.initRandomGraphWithFixedEdgeNumber();
                } while (!this.postInitCheck());
                break;
            }
            case 1: {
                do {
                    this.initRandomGraphWithFixedEdgeProbability();
                } while (!this.postInitCheck());
                break;
            }
            case 2: {
                do {
                    this.initRandomGraphWithBinaryValuedWeights();
                } while (!this.postInitCheck());
                break;
            }
            case 3: {
                this.initFullGraph();
                this.postInit();
                break;
            }
            case 5: {
                this.initStarGraph();
                this.postInit();
                break;
            }
            case 6: {
                this.initPath();
                this.postInit();
                break;
            }
            case 7: {
                this.initRandomTree();
                this.postInit();
                break;
            }
            case 8: {
                this.initLolliTree();
                this.postInit();
                break;
            }
            case 9: {
                this.initKTree();
                this.postInit();
                break;
            }
            case 10: {
                this.initSemi();
                this.postInit();
                break;
            }
            case 11: {
                this.initSemiP();
                this.postInit();
                break;
            }
            case 12: {
                this.initTrapLine();
                this.postInit();
            }
        }
    }

    private boolean postInitCheck() {
        this.graph.initSpeedupStructures();
        if (!this.isGraphConnected()) {
            return false;
        }
        this.schedule.callInitialize();
        return true;
    }

    private void postInit() {
        this.graph.initSpeedupStructures();
        this.schedule.callInitialize();
    }

    private boolean isGraphConnected() {
        GraphEdgeSelectionGenotype allEdges = new GraphEdgeSelectionGenotype(this.graph);
        Arrays.fill(allEdges.edgeSelection, true);
        int components = this.graph.numOfConnectedComponentsForSelectedEdges(allEdges);
        return components == 1;
    }

    private void initStarGraph() {
        RandomElement random = this.getRandomElement();
        this.graph = new Graph(this.numOfVertices);
        int numCircle = this.numOfVertices - 1;
        int i = 0;
        while (i < numCircle) {
            this.graph.addEdge(i, numCircle, 1);
            ++i;
        }
        i = 0;
        while (i < numCircle) {
            int j = i + 1;
            while (j < numCircle) {
                this.graph.addEdge(i, j, random.choose(2, this.maxWeight));
                ++j;
            }
            ++i;
        }
        this.graph.setLayoutX(this.numOfVertices - 1, 0.5f);
        this.graph.setLayoutY(this.numOfVertices - 1, 0.5f);
        i = 0;
        while (i < numCircle) {
            this.graph.setLayoutX(i, 0.5f + 0.5f * (float)Math.cos(Math.PI * 2 * (double)i / (double)numCircle));
            this.graph.setLayoutY(i, 0.5f + 0.5f * (float)Math.sin(Math.PI * 2 * (double)i / (double)numCircle));
            ++i;
        }
    }

    private void initPath() {
        this.graph = new Graph(this.numOfVertices);
        int i = 0;
        while (i < this.numOfVertices - 1) {
            this.graph.addEdge(i, i + 1, 1);
            ++i;
        }
        int sqrt = (int)Math.sqrt(this.numOfVertices);
        int rows = (int)Math.ceil((float)this.numOfVertices / (float)sqrt) - 1;
        int i2 = 0;
        while (i2 < this.numOfVertices) {
            this.graph.setLayoutX(i2, (float)(i2 / sqrt) / (float)rows);
            if (i2 / sqrt % 2 == 0) {
                this.graph.setLayoutY(i2, (float)(i2 - i2 / sqrt * sqrt) / (float)(sqrt - 1));
            } else {
                this.graph.setLayoutY(i2, 1.0f - (float)(i2 - i2 / sqrt * sqrt) / (float)(sqrt - 1));
            }
            ++i2;
        }
    }

    private void initRandomTree() {
        this.graph = new Graph(this.numOfVertices);
        int[] pruferNr = new int[this.numOfVertices - 2];
        RandomElement re = this.getRandomElement();
        int i = 0;
        while (i < this.numOfVertices - 2) {
            pruferNr[i] = re.choose(0, this.numOfVertices - 1);
            ++i;
        }
        int[] lookupMap = new int[pruferNr.length + 2];
        int i2 = 0;
        while (i2 < pruferNr.length) {
            int n = pruferNr[i2];
            lookupMap[n] = lookupMap[n] + 1;
            ++i2;
        }
        int startAt = 0;
        int i3 = 0;
        while (i3 < pruferNr.length) {
            int j = startAt;
            while (j < this.graph.getNumberOfNodes() && lookupMap[j] != 0) {
                ++j;
            }
            int n = pruferNr[i3];
            lookupMap[n] = lookupMap[n] - 1;
            int n2 = j;
            lookupMap[n2] = lookupMap[n2] + 1;
            startAt = lookupMap[pruferNr[i3]] == 0 && pruferNr[i3] < j ? pruferNr[i3] : j + 1;
            this.graph.addEdge(pruferNr[i3], j, 1);
            ++i3;
        }
        int node1 = startAt;
        while (node1 < this.graph.getNumberOfNodes() && lookupMap[node1] != 0) {
            ++node1;
        }
        int node2 = node1 + 1;
        while (node2 < this.graph.getNumberOfNodes() && lookupMap[node2] != 0) {
            ++node2;
        }
        this.graph.addEdge(node1, node2, 1);
    }

    private void initFullGraph() {
        RandomElement random = this.getRandomElement();
        this.graph = new Graph(this.numOfVertices);
        int i = 0;
        while (i < this.numOfVertices) {
            int j = i + 1;
            while (j < this.numOfVertices) {
                this.graph.addEdge(i, j, random.choose(1, this.maxWeight));
                ++j;
            }
            ++i;
        }
    }

    private void initRandomGraphWithFixedEdgeNumber() {
        int maxEdges = this.numOfVertices * (this.numOfVertices - 1) / 2;
        if (this.numOfEdges > maxEdges) {
            throw new RuntimeException("Too many edges requested in random graph creation.");
        }
        if (this.numOfEdges < this.numOfVertices - 1) {
            throw new RuntimeException("Too few edges requested in random graph creation.");
        }
        if (this.numOfEdges < maxEdges / 2) {
            this.initRandomGraphByEdgeCollection();
        } else {
            this.initRandomGraphByEdgeRemoval();
        }
    }

    private void initRandomGraphByEdgeCollection() {
        RandomElement random = this.getRandomElement();
        this.graph = new Graph(this.numOfVertices);
        int added = 0;
        while (added < this.numOfEdges) {
            int node2;
            int node1 = random.choose(this.numOfVertices) - 1;
            if (node1 == (node2 = random.choose(this.numOfVertices) - 1) || this.graph.containsEdge(node1, node2)) continue;
            this.graph.addEdge(node1, node2, random.choose(1, this.maxWeight));
            ++added;
        }
    }

    private void initRandomGraphByEdgeRemoval() {
        RandomElement random = this.getRandomElement();
        this.graph = new Graph(this.numOfVertices);
        int i = 0;
        while (i < this.numOfVertices) {
            int j = i + 1;
            while (j < this.numOfVertices) {
                this.graph.addEdge(i, j, random.choose(1, this.maxWeight));
                ++j;
            }
            ++i;
        }
        int maxEdges = this.numOfVertices * (this.numOfVertices - 1) / 2;
        int remaining = maxEdges - this.numOfEdges;
        while (remaining > 0) {
            int node2;
            int node1 = random.choose(this.numOfVertices) - 1;
            if (node1 == (node2 = random.choose(this.numOfVertices) - 1) || !this.graph.containsEdge(node1, node2)) continue;
            this.graph.removeEdge(node1, node2);
            --remaining;
        }
    }

    public void initRandomGraphWithFixedEdgeProbability() {
        RandomElement random = this.getRandomElement();
        this.graph = new Graph(this.numOfVertices);
        int i = 0;
        while (i < this.numOfVertices) {
            int j = i + 1;
            while (j < this.numOfVertices) {
                if (random.raw() < this.probForEdge) {
                    this.graph.addEdge(i, j, random.choose(1, this.maxWeight));
                }
                ++j;
            }
            ++i;
        }
    }

    private void initIngosGraph() {
        if ((this.verticesInTriangles - 1) % 2 != 0) {
            throw new RuntimeException("Illegal Number of Nodes in Triangles");
        }
        if (this.verticesInTriangles > this.numOfVertices) {
            throw new RuntimeException("Illegal Number of Nodes in Triangles");
        }
        this.graph = new Graph(this.numOfVertices);
        int verticesInClique = this.numOfVertices - this.verticesInTriangles + 1;
        int numOfTriangles = (this.verticesInTriangles - 1) / 2;
        int edgesInClique = verticesInClique * (verticesInClique - 1) / 2;
        int triangleEdgeWeightBase = edgesInClique + 1;
        float margin = 0.05f;
        float edgeLength = (1.0f - margin * 2.0f) / ((float)numOfTriangles + (float)(verticesInClique + 2) / (float)Math.PI);
        float triangleHeight = (float)Math.sin(1.0471975511965976) * edgeLength;
        float circleRadius = (1.0f - margin * 2.0f - edgeLength * (float)numOfTriangles) / 2.0f;
        float circleCenterX = 1.0f - margin - circleRadius;
        int i = 0;
        while (i < numOfTriangles) {
            this.graph.addEdge(i * 2, i * 2 + 1, triangleEdgeWeightBase * 2);
            this.graph.addEdge(i * 2, i * 2 + 2, triangleEdgeWeightBase * 3);
            this.graph.addEdge(i * 2 + 1, i * 2 + 2, triangleEdgeWeightBase * 2);
            this.graph.setLayoutX(i * 2, margin + edgeLength * (float)i);
            this.graph.setLayoutY(i * 2, 0.5f);
            this.graph.setLayoutX(i * 2 + 1, margin + edgeLength * ((float)i + 0.5f));
            this.graph.setLayoutY(i * 2 + 1, triangleHeight + 0.5f);
            ++i;
        }
        i = numOfTriangles * 2;
        while (i < this.numOfVertices) {
            int j = i + 1;
            while (j < this.numOfVertices) {
                this.graph.addEdge(i, j, 1);
                ++j;
            }
            int position = i - numOfTriangles * 2;
            double angle = Math.PI * 2 / (double)verticesInClique * (double)position + Math.PI;
            this.graph.setLayoutX(i, (float)((double)circleCenterX + Math.cos(angle) * (double)circleRadius));
            this.graph.setLayoutY(i, (float)(0.5 + Math.sin(angle) * (double)circleRadius));
            ++i;
        }
    }

    private void initRandomGraphWithBinaryValuedWeights() {
        RandomElement random = this.getRandomElement();
        int maxEdges = this.numOfVertices * (this.numOfVertices - 1) / 2;
        int edgesCount = 0;
        int i = 0;
        while (i < maxEdges) {
            if (random.raw() < this.probForEdge) {
                ++edgesCount;
            }
            ++i;
        }
        this.setPropertyNumberOfEdges(new Integer(edgesCount));
        if (this.numOfEdges > maxEdges) {
            throw new RuntimeException("Too many edges requested in random graph creation.");
        }
        this.initRandomGraphByEdgeCollectionBinaryValue();
    }

    private void initRandomGraphByEdgeCollectionBinaryValue() {
        RandomElement random = this.getRandomElement();
        this.graph = new Graph(this.numOfVertices);
        int added = 0;
        int bc = 1;
        while (added < this.numOfEdges) {
            int node2;
            int node1 = random.choose(this.numOfVertices) - 1;
            if (node1 == (node2 = random.choose(this.numOfVertices) - 1) || this.graph.containsEdge(node1, node2)) continue;
            this.graph.addEdge(node1, node2, bc);
            bc *= 2;
            ++added;
        }
    }

    private void initLolliTree() {
        float posY;
        float posX;
        this.graph = new Graph(this.numOfVertices);
        int i = 1;
        while (i < this.verticesLolli) {
            this.graph.addEdge(0, i, 1);
            ++i;
        }
        i = this.verticesLolli - 1;
        while (i < this.numOfVertices - 1) {
            this.graph.addEdge(i, i + 1, 1);
            ++i;
        }
        float centerX = 0.25f;
        float centerY = 0.5f;
        this.graph.setLayoutX(0, centerX);
        this.graph.setLayoutY(0, centerY);
        int i2 = 1;
        while (i2 < this.verticesLolli) {
            posX = (float)Math.cos(Math.PI * 2 / (double)(this.verticesLolli - 1) * (double)i2) / 5.0f + centerX;
            posY = (float)Math.sin(Math.PI * 2 / (double)(this.verticesLolli - 1) * (double)i2) / 5.0f + centerY;
            this.graph.setLayoutX(i2, posX);
            this.graph.setLayoutY(i2, posY);
            ++i2;
        }
        i2 = this.verticesLolli;
        while (i2 < this.numOfVertices) {
            posX = centerX + 0.2f + (1.0f - centerX - 0.1f) / (float)(this.numOfVertices - this.verticesLolli + 1) * (float)(i2 - this.verticesLolli + 1);
            posY = centerY;
            this.graph.setLayoutX(i2, posX);
            this.graph.setLayoutY(i2, posY);
            ++i2;
        }
    }

    private void initKTree() {
        int i;
        this.graph = new Graph(this.numOfVertices);
        int temp = 1 + this.numOfVertices * (this.degreeK - 1);
        int numOfLevels = (int)Math.ceil(Math.log(temp) / Math.log(this.degreeK));
        int l = 0;
        while (l < numOfLevels - 1) {
            int nodesOnLevel = (int)Math.round(Math.exp((double)l * Math.log(this.degreeK)));
            int offset = (int)Math.round((Math.exp((double)l * Math.log(this.degreeK)) - 1.0) / (double)(this.degreeK - 1));
            int k = 0;
            i = 0;
            block1: while (i < nodesOnLevel) {
                int j = 0;
                while (j < this.degreeK) {
                    if (offset + nodesOnLevel + k >= this.numOfVertices) break block1;
                    this.graph.addEdge(offset + i, offset + nodesOnLevel + k, 1);
                    ++k;
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        int j = 0;
        int l2 = 0;
        while (l2 < numOfLevels) {
            int nodesOnLevel = (int)Math.round(Math.exp((double)l2 * Math.log(this.degreeK)));
            float posY = 1.0f / (float)numOfLevels * (float)l2;
            i = 0;
            while (i < nodesOnLevel) {
                float posX = 1.0f / (float)(nodesOnLevel + 1) * (float)(i + 1);
                this.graph.setLayoutX(j, posX);
                this.graph.setLayoutY(j, posY);
                if (++j >= this.numOfVertices) {
                    return;
                }
                ++i;
            }
            ++l2;
        }
    }

    private void initSemiP() {
        this.graph = new Graph(this.numOfVertices);
        int i = 0;
        while (i < this.numOfEdges) {
            this.graph.addEdge(2 * i, 2 * i + 1, 1);
            ++i;
        }
        RandomElement random = this.getRandomElement();
        int i2 = 0;
        while (i2 < this.numOfVertices - 1) {
            int j = i2 + 1;
            while (j < this.numOfVertices) {
                if (random.uniform(0.0, 1.0) < this.probForEdge) {
                    this.graph.addEdge(i2, j, 1);
                }
                ++j;
            }
            ++i2;
        }
    }

    private void initSemi() {
        this.graph = new Graph(this.numOfVertices);
        int i = 0;
        while (i < Math.round(this.numOfVertices / 2)) {
            this.graph.addEdge(2 * i, 2 * i + 1, 1);
            ++i;
        }
        RandomElement random = this.getRandomElement();
        int missing = Math.round(this.numOfEdges - this.numOfVertices / 2);
        while (missing > 0) {
            int end;
            int start = random.choose(this.numOfVertices) - 1;
            if (start == (end = random.choose(this.numOfVertices) - 1) || this.graph.containsEdge(start, end)) continue;
            this.graph.addEdge(start, end, 1);
            --missing;
        }
    }

    private void initTrapLine() {
        this.graph = new Graph(this.numOfVertices);
        int leftLine = (this.numOfVertices - 2) / 2;
        int rightLine = leftLine - 1;
        float spacing = 1.0f / (float)(this.numOfVertices - 2);
        int i = 0;
        while (i < leftLine) {
            this.graph.setLayoutX(i, ((float)i + 0.5f) * spacing);
            this.graph.setLayoutY(i, 0.4f);
            ++i;
        }
        i = leftLine;
        while (i < leftLine + rightLine + 1) {
            this.graph.setLayoutX(i, ((float)i + 0.5f) * spacing);
            this.graph.setLayoutY(i, 0.5f);
            ++i;
        }
        this.graph.setLayoutX(this.numOfVertices - 2, 0.5f - 0.5f * spacing);
        this.graph.setLayoutY(this.numOfVertices - 2, 0.6f);
        this.graph.setLayoutX(this.numOfVertices - 1, 0.5f - 1.5f * spacing);
        this.graph.setLayoutY(this.numOfVertices - 1, 0.6f);
        i = 0;
        while (i < this.numOfVertices - 3) {
            this.graph.addEdge(i, i + 1, 1);
            ++i;
        }
        this.graph.addEdge(leftLine, this.numOfVertices - 2, 1);
        this.graph.addEdge(this.numOfVertices - 2, this.numOfVertices - 1, 1);
    }

    public Inspector getInspector() {
        return new GraphEdgeSelectionConfigurationPanel(this);
    }

    public Configuration getConfiguration() {
        GraphEdgeSelectionConfiguration conf = new GraphEdgeSelectionConfiguration();
        Configuration.getConfigurationFor(this, conf);
        return conf;
    }

    public static class Graph
    implements Serializable {
        protected int numberOfNodes;
        protected int numberOfEdges;
        protected float[] nodeLayoutX;
        protected float[] nodeLayoutY;
        protected Edge[] edgeLUT;
        protected ArrayList[] edges;
        protected boolean mstIsKnown;
        protected int cachedMSTWeight;
        protected boolean[] cachedMSTEdgeSelection;
        protected ArrayList[] sets;
        protected int[] repr;

        public Graph(int numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            this.numberOfEdges = 0;
            this.edges = new ArrayList[numberOfNodes];
            int i = 0;
            while (i < numberOfNodes) {
                this.edges[i++] = new ArrayList();
            }
            this.nodeLayoutX = new float[numberOfNodes];
            this.nodeLayoutY = new float[numberOfNodes];
            this.circleLayout();
            this.mstIsKnown = false;
        }

        public void initSpeedupStructures() {
            if (this.edgeLUT != null) {
                System.out.println("something may be wrong! Method initSpeedupStructures() should not be called more than once!");
            }
            this.edgeLUT = new Edge[this.getNumberOfEdges()];
            int count = 0;
            int i = 0;
            while (i < this.numberOfNodes) {
                int j = 0;
                while (j < this.edges[i].size()) {
                    Edge e = (Edge)this.edges[i].get(j);
                    if (e.startNode <= e.endNode) {
                        e.indexInGenotypeArray = count;
                        this.edgeLUT[count] = e;
                        ++count;
                    } else {
                        ArrayList endEdges = this.edges[e.endNode];
                        int k = 0;
                        while (k < endEdges.size()) {
                            Edge e2 = (Edge)endEdges.get(k);
                            if (e2.endNode == e.startNode) {
                                e.indexInGenotypeArray = e2.indexInGenotypeArray;
                                break;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }

        public Edge edgeForSpeedupIndex(int index) {
            return this.edgeLUT[index];
        }

        public int findEdgeSelectionIndexForEdge(int startNode, int endNode) {
            if (startNode > endNode) {
                int temp = startNode;
                startNode = endNode;
                endNode = temp;
            }
            int j = 0;
            ArrayList nodeEdges = this.edges[startNode];
            while (j < nodeEdges.size()) {
                Edge e = (Edge)nodeEdges.get(j++);
                if (e.endNode != endNode) continue;
                return e.indexInGenotypeArray;
            }
            return -1;
        }

        public Edge[] getIncidentEdgesForNode(int node) {
            Edge[] retEdges = new Edge[this.edges[node].size()];
            int i = 0;
            while (i < retEdges.length) {
                retEdges[i] = (Edge)this.edges[node].get(i);
                ++i;
            }
            return retEdges;
        }

        public ArrayList getSelectedIncidentEdgesForNode(int node, GraphEdgeSelectionGenotype gene) {
            ArrayList retEdges = new ArrayList();
            boolean[] edgeSelection = gene.getEdgeSelection();
            ArrayList incidentEdges = this.edges[node];
            int totalEdges = incidentEdges.size();
            int i = 0;
            while (i < totalEdges) {
                Edge e = (Edge)incidentEdges.get(i);
                if (edgeSelection[e.indexInGenotypeArray]) {
                    retEdges.add(this.edges[node].get(i));
                }
                ++i;
            }
            return retEdges;
        }

        public int getNumberOfSelectedIncidentEdgesForNode(int node, GraphEdgeSelectionGenotype gene) {
            int num = 0;
            boolean[] edgeSelection = gene.getEdgeSelection();
            ArrayList incidentEdges = this.edges[node];
            int totalEdges = incidentEdges.size();
            int i = 0;
            while (i < totalEdges) {
                Edge e = (Edge)incidentEdges.get(i);
                if (edgeSelection[e.indexInGenotypeArray]) {
                    ++num;
                }
                ++i;
            }
            return num;
        }

        public boolean containsEdge(int v, int w) {
            Edge e = new Edge(null, v, w, 0);
            return this.edges[v].contains(e);
        }

        public synchronized boolean addEdge(int v, int w, int weight) {
            if (!this.containsEdge(v, w)) {
                if (v != w) {
                    this.edges[v].add(new Edge(this, v, w, weight));
                    this.edges[w].add(new Edge(this, w, v, weight));
                } else {
                    this.edges[v].add(new Edge(this, v, v, weight));
                }
                ++this.numberOfEdges;
                this.mstIsKnown = false;
                return true;
            }
            return false;
        }

        public synchronized void removeEdge(int v, int w) {
            if (this.containsEdge(v, w)) {
                this.edges[v].remove(new Edge(this, v, w, 0));
                this.edges[w].remove(new Edge(this, w, v, 0));
                --this.numberOfEdges;
                this.mstIsKnown = false;
            }
        }

        public int getNumberOfEdges() {
            return this.numberOfEdges;
        }

        public int getNumberOfNodes() {
            return this.numberOfNodes;
        }

        public void circleLayout() {
            int i = 0;
            while (i < this.numberOfNodes) {
                this.nodeLayoutX[i] = 0.5f + 0.5f * (float)Math.cos(Math.PI * 2 * (double)i / (double)this.numberOfNodes);
                this.nodeLayoutY[i] = 0.5f + 0.5f * (float)Math.sin(Math.PI * 2 * (double)i / (double)this.numberOfNodes);
                ++i;
            }
        }

        public void setLayoutX(int node, float value) {
            this.nodeLayoutX[node] = value;
        }

        public void setLayoutY(int node, float value) {
            this.nodeLayoutY[node] = value;
        }

        public float getLayoutX(int node) {
            return this.nodeLayoutX[node];
        }

        public float getLayoutY(int node) {
            return this.nodeLayoutY[node];
        }

        public void initUF() {
            this.sets = new ArrayList[this.getNumberOfNodes()];
            int i = 0;
            while (i < this.getNumberOfNodes()) {
                this.sets[i] = new ArrayList();
                this.sets[i].add(new Integer(i));
                ++i;
            }
            this.repr = new int[this.getNumberOfNodes()];
            i = 0;
            while (i < this.getNumberOfNodes()) {
                this.repr[i] = i;
                ++i;
            }
        }

        protected void union(int oa, int ob) {
            int a = this.repr[oa];
            int b = this.repr[ob];
            ArrayList listA = this.sets[a];
            ArrayList listB = this.sets[b];
            int i = 0;
            while (i < listB.size()) {
                Integer num = (Integer)listB.get(i);
                this.repr[num.intValue()] = a;
                ++i;
            }
            listA.addAll(listB);
        }

        protected boolean sameClass(int a, int b) {
            return this.repr[a] == this.repr[b];
        }

        protected synchronized void calcMST() {
            int numEdges = this.getNumberOfEdges();
            Object[] sortedEdges = new Edge[numEdges];
            int i = 0;
            while (i < numEdges) {
                sortedEdges[i] = this.edgeForSpeedupIndex(i);
                ++i;
            }
            Arrays.sort(sortedEdges);
            boolean[] selEdges = new boolean[numEdges];
            int i2 = 0;
            while (i2 < numEdges) {
                selEdges[i2] = false;
                ++i2;
            }
            int accWeight = 0;
            this.initUF();
            int i3 = 0;
            while (i3 < numEdges) {
                Object testEdge = sortedEdges[i3];
                if (!this.sameClass(((Edge)testEdge).startNode, ((Edge)testEdge).endNode)) {
                    selEdges[((Edge)testEdge).indexInGenotypeArray] = true;
                    accWeight += ((Edge)testEdge).weight;
                    this.union(((Edge)testEdge).endNode, ((Edge)testEdge).startNode);
                }
                ++i3;
            }
            this.mstIsKnown = true;
            this.cachedMSTWeight = accWeight;
            this.cachedMSTEdgeSelection = selEdges;
        }

        public int getMSTWeight() {
            if (!this.mstIsKnown) {
                this.calcMST();
            }
            return this.cachedMSTWeight;
        }

        public boolean[] getMSTEdgeSelection() {
            if (!this.mstIsKnown) {
                this.calcMST();
            }
            return this.cachedMSTEdgeSelection;
        }

        public int weightOfMST() {
            return this.getMSTWeight();
        }

        public int getSumOfWeightsOfAllEdges() {
            int sum = 0;
            int i = 0;
            while (i < this.numberOfNodes) {
                int j = 0;
                while (j < this.edges[i].size()) {
                    Edge e = (Edge)this.edges[i].get(j);
                    if (e.startNode <= e.endNode) {
                        sum += e.weight;
                    }
                    ++j;
                }
                ++i;
            }
            return sum;
        }

        public int getMaxEdgeWeight() {
            int maxWeight = 0;
            int i = 0;
            while (i < this.numberOfNodes) {
                int j = 0;
                while (j < this.edges[i].size()) {
                    Edge e = (Edge)this.edges[i].get(j);
                    maxWeight = Math.max(maxWeight, e.getWeight());
                    ++j;
                }
                ++i;
            }
            return maxWeight;
        }

        public int getSumOfWeightsOfAllSelectedEdges(GraphEdgeSelectionGenotype gen) {
            int sum = 0;
            int i = 0;
            while (i < this.numberOfNodes) {
                int j = 0;
                while (j < this.edges[i].size()) {
                    Edge e = (Edge)this.edges[i].get(j);
                    if (e.startNode <= e.endNode) {
                        sum += e.getIsSelected(gen) ? e.weight : 0;
                    }
                    ++j;
                }
                ++i;
            }
            return sum;
        }

        protected void dfsAlongSelectedEdges(int node, GraphEdgeSelectionGenotype gen, boolean[] visited) {
            visited[node] = true;
            int i = 0;
            while (i < this.edges[node].size()) {
                Edge e = (Edge)this.edges[node].get(i);
                if (gen.getEdgeSelection()[e.indexInGenotypeArray] && !visited[e.endNode]) {
                    this.dfsAlongSelectedEdges(e.endNode, gen, visited);
                }
                ++i;
            }
        }

        public int getNumberOfSelectedEdges(GraphEdgeSelectionGenotype gen) {
            int sum = 0;
            boolean[] sel = gen.getEdgeSelection();
            int i = 0;
            while (i < sel.length) {
                sum += sel[i] ? 1 : 0;
                ++i;
            }
            return sum;
        }

        public int numOfConnectedComponentsForSelectedEdges(GraphEdgeSelectionGenotype gen) {
            boolean[] visited = new boolean[this.numberOfNodes];
            int i = 0;
            while (i < this.numberOfNodes) {
                visited[i] = false;
                ++i;
            }
            int numOfComponents = 0;
            int i2 = 0;
            while (i2 < this.numberOfNodes) {
                if (!visited[i2]) {
                    ++numOfComponents;
                    this.dfsAlongSelectedEdges(i2, gen, visited);
                }
                ++i2;
            }
            return numOfComponents;
        }

        public void uniformlySelectRandomEdges(RandomElement random, GraphEdgeSelectionGenotype gen) {
            boolean[] selection = gen.getEdgeSelection();
            int i = 0;
            while (i < selection.length) {
                selection[i] = random.choose(2) == 1;
                ++i;
            }
        }

        public static class Edge
        implements Serializable,
        Comparable {
            protected Graph graph;
            protected int startNode;
            protected int endNode;
            protected int weight;
            protected int indexInGenotypeArray;

            public Edge(Graph graph, int v, int w, int weight) {
                this.graph = graph;
                this.startNode = v;
                this.endNode = w;
                this.weight = weight;
                this.indexInGenotypeArray = -1;
            }

            public boolean equals(Object o) {
                if (!(o instanceof Edge)) {
                    return false;
                }
                Edge e = (Edge)o;
                return this.startNode == e.startNode && this.endNode == e.endNode;
            }

            public int hashCode() {
                return 3628801 * this.startNode + 40321 * this.endNode;
            }

            public boolean getIsSelected(GraphEdgeSelectionGenotype g) {
                return g.getEdgeSelection()[this.indexInGenotypeArray];
            }

            public int getStartNode() {
                return this.startNode;
            }

            public int getEndNode() {
                return this.endNode;
            }

            public int getWeight() {
                return this.weight;
            }

            public int compareTo(Object o) {
                Edge other = (Edge)o;
                if (this.weight < other.weight) {
                    return -1;
                }
                if (this.weight == other.weight) {
                    return 0;
                }
                return 1;
            }

            public int getIndexInGenotypeArray() {
                return this.indexInGenotypeArray;
            }
        }
    }
}

