/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.core.util.FreakMath;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import java.util.BitSet;

public class KPointCrossover
extends MultiPairwiseCrossover
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    protected int k;

    public KPointCrossover(OperatorGraph graph) {
        super(graph);
        if (graph.getSchedule().getGenotypeSearchSpace() instanceof HasDimension) {
            this.setPropertyK(new Integer(1));
        }
    }

    public void initialize() {
        super.initialize();
        int dim = ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension();
        if (this.k > dim) {
            this.k = dim;
        }
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof GeneralString) && !(searchspace instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        SearchSpace searchspace = this.graph.getSchedule().getGenotypeSearchSpace();
        int dimension = ((HasDimension)((Object)searchspace)).getDimension();
        int[] breaks = FreakMath.getKofN(this.graph.getSchedule(), this.k, dimension);
        int bi = 0;
        boolean first = true;
        if (searchspace instanceof BitString) {
            BitSet bs1 = ((BitStringGenotype)ind1.getGenotype()).getBitSet();
            BitSet bs2 = ((BitStringGenotype)ind2.getGenotype()).getBitSet();
            BitSet bsOut = (BitSet)bs1.clone();
            int i = 0;
            while (i < dimension) {
                if (breaks[bi] == i) {
                    boolean bl = first = !first;
                    if (bi < breaks.length - 1) {
                        ++bi;
                    }
                }
                if (!first) {
                    bsOut.set(i, bs2.get(i));
                }
                ++i;
            }
            return new Individual(this.graph.getSchedule(), new BitStringGenotype(bsOut, dimension), new Individual[]{ind1, ind2});
        }
        int[] gs1 = ((GeneralStringGenotype)ind1.getGenotype()).getIntArray();
        int[] gs2 = ((GeneralStringGenotype)ind2.getGenotype()).getIntArray();
        int[] gsOut = (int[])gs1.clone();
        int numChars = ((GeneralString)this.graph.getSchedule().getGenotypeSearchSpace()).getNumChars();
        int i = 0;
        while (i < dimension) {
            if (breaks[bi] == i) {
                boolean bl = first = !first;
                if (bi < breaks.length - 1) {
                    ++bi;
                }
            }
            if (!first) {
                gsOut[i] = gs2[i];
            }
            ++i;
        }
        return new Individual(this.graph.getSchedule(), new GeneralStringGenotype(gsOut, numChars), new Individual[]{ind1, ind2});
    }

    public void setPropertyK(Integer num) {
        if (num >= 0 && num <= ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension()) {
            this.k = num;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForK() {
        return "Number of randomly chosen crossover points.";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    public String getDescription() {
        return "Chooses k crossing points at random and performs a k point crossover.";
    }

    public String getName() {
        return "k-Point Crossover";
    }
}

