/*
 * Decompiled with CFR 0.152.
 */
package freak.core.util;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import java.util.Arrays;

public class FreakMath {
    public static final int NO_ELEMENT = -1;

    public static int[] getKofN(Schedule schedule, int k, int n) {
        int[] a = new int[n];
        int[] result = new int[k];
        RandomElement re = schedule.getRandomElement();
        int i = 0;
        while (i < k) {
            int j = i < n - 1 ? re.choose(i, n - 1) : i;
            result[i] = a[j] == 0 ? j : a[j] - 1;
            a[j] = a[i] == 0 ? i + 1 : a[i];
            ++i;
        }
        if (k < n) {
            Arrays.sort(result);
        }
        return result;
    }

    public static int[][] getKDisjointSetsOfNNumbersExcludeH(Schedule schedule, int k, int n, int h) {
        int[] a = new int[n];
        int setSize = (n - h) / k;
        int noBiggerSets = (n - h) % k;
        if (noBiggerSets > 0) {
            ++setSize;
        }
        int[][] result = new int[k][setSize];
        int set = 0;
        int position = 0;
        RandomElement re = schedule.getRandomElement();
        int i = 0;
        while (i < n) {
            if (i == n - h) break;
            int j = i < n - 1 ? re.choose(i, n - 1) : i;
            result[set][position] = a[j] == 0 ? j : a[j] - 1;
            a[j] = a[i] == 0 ? i + 1 : a[i];
            ++set;
            if ((set %= k) == 0) {
                ++position;
            }
            ++i;
        }
        if (noBiggerSets != 0) {
            i = noBiggerSets;
            while (i < k) {
                result[i][position] = -1;
                ++i;
            }
        }
        return result;
    }

    public static int[][] getKDisjointSetsOfNNumbers(Schedule schedule, int k, int n) {
        return FreakMath.getKDisjointSetsOfNNumbersExcludeH(schedule, k, n, 0);
    }
}

