/*
 * Decompiled with CFR 0.152.
 */
package freak.core.parametercontroller;

import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphSyntaxException;
import freak.core.graph.Operator;
import freak.core.graph.OperatorGraph;
import freak.core.graph.UnassignedParameterException;
import freak.core.modulesupport.AbstractBasicModule;
import freak.core.modulesupport.PropertyManager;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.parametercontroller.ParameterController;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;

public abstract class AbstractParameterController
extends AbstractBasicModule
implements ParameterController,
CompatibleWithDifferentSearchSpaces {
    protected HashMap parameters;
    protected OperatorGraph opGraph;
    private transient Method getterMethod = null;
    private transient Method setterMethod = null;

    public AbstractParameterController(OperatorGraph opGraph) {
        this.opGraph = opGraph;
        this.parameters = new HashMap();
    }

    public Schedule getSchedule() {
        return this.opGraph.getSchedule();
    }

    public void addParameter(String name, Class type) {
        this.getterMethod = null;
        this.setterMethod = null;
        ParameterWrapper tmp = new ParameterWrapper();
        tmp.type = type;
        tmp.operator = null;
        tmp.propName = null;
        this.parameters.put(name, tmp);
    }

    public void objectRemoved(Object obj) {
        String[] pNames = this.getListOfParameters();
        int i = 0;
        while (i < pNames.length) {
            ParameterWrapper pw = (ParameterWrapper)this.parameters.get(pNames[i]);
            if (pw.operator == obj) {
                this.removePropertyForParameter(pNames[i]);
            }
            ++i;
        }
    }

    public void removePropertyForParameter(String name) {
        this.getterMethod = null;
        this.setterMethod = null;
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(name);
        if (pw == null) {
            throw new RuntimeException("No Parameter " + name + " in parameters map");
        }
        pw.operator = null;
        pw.propName = null;
    }

    protected String removePackages(String source) {
        int lastIndexOfDot = source.lastIndexOf(".");
        String tmp = source.substring(lastIndexOfDot + 1);
        return tmp;
    }

    public void setPropertyForParameter(String paraName, Operator operator, String propName) throws RuntimeException {
        this.getterMethod = null;
        this.setterMethod = null;
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(paraName);
        if (pw == null) {
            throw new RuntimeException("No Parameter " + paraName + " in parameters map");
        }
        ArrayList l = new ArrayList(Arrays.asList(operator.getListOfPropertyNames()));
        if (!l.contains(propName)) {
            throw new RuntimeException("No Property " + propName + " in " + operator.getClass());
        }
        if (!PropertyManager.assignableFrom(operator.getPropertyType(propName), this.getParameterType(paraName))) {
            throw new RuntimeException("type mismatch in setPropertyForParameter, para=" + this.getParameterType(paraName) + ", prop=" + operator.getPropertyType(propName));
        }
        pw.operator = operator;
        pw.propName = propName;
    }

    public Class getParameterType(String name) throws NoSuchElementException {
        Class tmp = ((ParameterWrapper)this.parameters.get((Object)name)).type;
        if (tmp == null) {
            throw new NoSuchElementException("No event with name " + name + " in events map");
        }
        return tmp;
    }

    public String[] getListOfParameters() {
        Object[] tmp = this.parameters.keySet().toArray();
        int i = 0;
        while (i < tmp.length && tmp[i] != null) {
            ++i;
        }
        int size = i;
        String[] out = new String[size];
        i = 0;
        while (i < size) {
            out[i] = (String)tmp[i];
            ++i;
        }
        return out;
    }

    public Object getParameter(String name) {
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(name);
        if (pw == null) {
            throw new NoSuchElementException("No pw for parameter:" + name);
        }
        if (pw.operator != null && pw.propName != null) {
            Operator operator = pw.operator;
            if (this.getterMethod == null) {
                this.getterMethod = operator.getGetterMethod(pw.propName);
            }
            try {
                return this.getterMethod.invoke((Object)operator, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setParameter(String name, Object value) {
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(name);
        if (pw == null) {
            throw new NoSuchElementException("No pw for parameter:" + name);
        }
        if (pw.operator != null && pw.propName != null) {
            Operator operator = pw.operator;
            if (this.setterMethod == null) {
                this.setterMethod = pw.operator.getSetterMethod(pw.propName);
            }
            Object[] arg = new Object[]{value};
            try {
                this.setterMethod.invoke((Object)operator, arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Operator getOperatorForParameter(String paramName) {
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(paramName);
        if (pw == null) {
            throw new NoSuchElementException("No Parameter with name " + paramName + " in parameters map");
        }
        return pw.operator;
    }

    public String getPropNameForParameter(String paramName) {
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(paramName);
        if (pw == null) {
            throw new NoSuchElementException("No Parameter with name " + paramName + " in parameters map");
        }
        return pw.propName;
    }

    public String getPropDescriptionForParameter(String paramName) {
        String shortName;
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(paramName);
        if (pw == null) {
            throw new NoSuchElementException("No Parameter with name " + paramName + " in parameters map");
        }
        if (pw.operator != null && (shortName = PropertyManager.getShortDescriptionFor(pw.operator, pw.propName)) != null) {
            return shortName;
        }
        return pw.propName;
    }

    public void checkSyntax() throws GraphSyntaxException {
    }

    protected void fireExceptionIfParameterIsUnassigned(String parameter) throws UnassignedParameterException {
        ParameterWrapper pw = (ParameterWrapper)this.parameters.get(parameter);
        if (pw == null) {
            throw new RuntimeException("No Parameter " + parameter + " in parameters map");
        }
        if (pw.operator == null) {
            throw new UnassignedParameterException("Parameter " + parameter + " is unassigned in Parameter Controller " + this.getName());
        }
    }

    public void initialize() {
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
    }

    private static class ParameterWrapper
    implements Serializable {
        public Class type;
        public Operator operator;
        public String propName;

        private ParameterWrapper() {
        }
    }
}

