/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class Needle
extends AbstractStaticSingleObjectiveFitnessFunction {
    private BitStringGenotype needlePos;

    public Needle(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        int dim = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if (this.needlePos != null && this.needlePos.size() != dim) {
            BitSet bs = new BitSet(dim);
            bs.set(0, dim);
            this.needlePos = new BitStringGenotype(bs, dim);
        }
    }

    public double evaluate(Genotype genotype) {
        if (((BitStringGenotype)genotype).getBitSet().equals(this.needlePos.getBitSet())) {
            return 1.0;
        }
        return 0.0;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return this.needlePos.getBitSet().length();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        return this.needlePos;
    }

    public String getDescription() {
        return "The fitness value of each individual is zero except for one point in the whole search space. There is no clue to the direction of the optimum, so we search a needle in a haystack. This needle has got a fitness value of 1.";
    }

    public String getName() {
        return "Needle";
    }
}

