/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a copy of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 */

package freak.gui.scheduleeditor;

import freak.gui.*;

/**
 * This is a simple modal dialog that displays some help-text and contains an
 * "Close"-button.
 * 
 * @author  Oliver
 */
public class HelpDialog extends javax.swing.JDialog {

	/** Creates new form HelpDialog */
	public HelpDialog(java.awt.Dialog parent, String helpText) {
		super(parent, true);
		initComponents();
		setSize(360, 300);
		setLocationRelativeTo(parent);
		Util.displayText(taHelp, helpText);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() { //GEN-BEGIN:initComponents
		java.awt.GridBagConstraints gridBagConstraints;

		jScrollPane1 = new javax.swing.JScrollPane();
		taHelp = new javax.swing.JTextArea();
		buHelp = JButtonFactory.newButton();

		getContentPane().setLayout(new java.awt.GridBagLayout());

		setTitle("Help");
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				closeDialog(evt);
			}
		});

		taHelp.setEditable(false);
		taHelp.setLineWrap(true);
		taHelp.setWrapStyleWord(true);
		jScrollPane1.setViewportView(taHelp);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.weighty = 1.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		getContentPane().add(jScrollPane1, gridBagConstraints);

		buHelp.setMnemonic('c');
		buHelp.setText("Close");
		buHelp.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				buHelpActionPerformed(evt);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		getContentPane().add(buHelp, gridBagConstraints);

		pack();
	} //GEN-END:initComponents

	private void buHelpActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_buHelpActionPerformed
		closeDialog(null);
	} //GEN-LAST:event_buHelpActionPerformed

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt) { //GEN-FIRST:event_closeDialog
		setVisible(false);
		dispose();
	} //GEN-LAST:event_closeDialog

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton buHelp;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JTextArea taHelp;
	// End of variables declaration//GEN-END:variables

}
