/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.gpas;

import freak.core.control.Actions;
import freak.core.control.GenerationIndex;
import freak.core.control.Replay;
import freak.core.control.RunControl;
import freak.core.control.Schedule;
import freak.core.control.StateListener;
import freak.gui.runframe.SingleExtensionFileFilter;
import freak.rinterface.model.ScheduleConfigurator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class GPASDialog
extends JDialog
implements StateListener {
    private static final long serialVersionUID = 1L;
    private JTextField jTextField = null;
    private JButton jButton = null;
    private File dataFile = null;
    private File testFile = null;
    private JButton jButton1 = null;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JTextField jTextField1 = null;
    private JTextField jTextField2 = null;
    private JButton jButton2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JLabel jLabel6 = null;
    private JTextField jTextField3 = null;
    private JButton jButton3 = null;
    private JProgressBar jProgressBar = null;
    private RunControl runControl = null;
    private JLabel jLabel7 = null;
    private JButton jButton4 = null;
    private int generations = 10000;
    private int runs = 1;
    private JLabel jLabel8 = null;
    private JLabel jLabel9 = null;
    private JLabel jLabel10 = null;
    private JLabel jLabel11 = null;
    private JTextField jTextField4 = null;
    private JLabel jLabel12 = null;
    private JTextField jTextField5 = null;
    private JTextField jTextField6 = null;
    private JLabel jLabel13 = null;
    private JLabel jLabel14 = null;
    private JLabel jLabel15 = null;
    private JLabel jLabel16 = null;
    private JLabel jLabel17 = null;
    private JTextField jTextField7 = null;

    public GPASDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(640, 480);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Genetic Programming for Association Studies");
        this.setSize(new Dimension(640, 480));
        this.jButton4.setEnabled(false);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridy = 3;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridy = 3;
            this.jLabel17 = new JLabel();
            this.jLabel17.setText(" Save result as    ");
            GridBagConstraints gridBagConstraints141 = new GridBagConstraints();
            gridBagConstraints141.gridx = 1;
            gridBagConstraints141.gridy = 15;
            this.jLabel16 = new JLabel();
            this.jLabel16.setText(" ");
            GridBagConstraints gridBagConstraints131 = new GridBagConstraints();
            gridBagConstraints131.gridx = 1;
            gridBagConstraints131.gridy = 8;
            this.jLabel15 = new JLabel();
            this.jLabel15.setText(" ");
            GridBagConstraints gridBagConstraints121 = new GridBagConstraints();
            gridBagConstraints121.gridx = 1;
            gridBagConstraints121.gridy = 1;
            this.jLabel14 = new JLabel();
            this.jLabel14.setText(" ");
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.gridx = 0;
            gridBagConstraints111.anchor = 17;
            gridBagConstraints111.gridy = 11;
            this.jLabel13 = new JLabel();
            this.jLabel13.setText(" Min ratio");
            GridBagConstraints gridBagConstraints101 = new GridBagConstraints();
            gridBagConstraints101.fill = 1;
            gridBagConstraints101.gridy = 11;
            gridBagConstraints101.weightx = 1.0;
            gridBagConstraints101.gridx = 1;
            GridBagConstraints gridBagConstraints91 = new GridBagConstraints();
            gridBagConstraints91.fill = 1;
            gridBagConstraints91.gridy = 10;
            gridBagConstraints91.weightx = 1.0;
            gridBagConstraints91.gridx = 1;
            GridBagConstraints gridBagConstraints81 = new GridBagConstraints();
            gridBagConstraints81.gridx = 0;
            gridBagConstraints81.anchor = 17;
            gridBagConstraints81.gridy = 10;
            this.jLabel12 = new JLabel();
            this.jLabel12.setText(" Min occurences    ");
            GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
            gridBagConstraints71.fill = 1;
            gridBagConstraints71.gridy = 9;
            gridBagConstraints71.weightx = 1.0;
            gridBagConstraints71.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 9;
            this.jLabel11 = new JLabel();
            this.jLabel11.setText(" Save graph as");
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.gridx = 1;
            gridBagConstraints51.gridy = 18;
            this.jLabel10 = new JLabel();
            this.jLabel10.setText(" ");
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 1;
            gridBagConstraints41.gridy = 13;
            this.jLabel9 = new JLabel();
            this.jLabel9.setText(" ");
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 1;
            gridBagConstraints31.gridy = 6;
            this.jLabel8 = new JLabel();
            this.jLabel8.setText(" ");
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 3;
            gridBagConstraints21.gridy = 19;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 19;
            this.jLabel7 = new JLabel();
            this.jLabel7.setText(" Progress");
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.gridy = 19;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 3;
            gridBagConstraints15.gridy = 16;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.gridy = 16;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.gridx = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.gridy = 16;
            this.jLabel6 = new JLabel();
            this.jLabel6.setText(" Test data set    ");
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = 14;
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Discrimination");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 7;
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Identification of interactions");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 0;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("General settings");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 17;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 5;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 5;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(" Generations    ");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 4;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(" Runs");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 2;
            this.jLabel = new JLabel();
            this.jLabel.setText(" Data set");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 12;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJButton(), gridBagConstraints);
            this.jContentPane.add((Component)this.getJTextField(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getJButton1(), gridBagConstraints2);
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints3);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints4);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints5);
            this.jContentPane.add((Component)this.getJTextField1(), gridBagConstraints7);
            this.jContentPane.add((Component)this.getJTextField2(), gridBagConstraints8);
            this.jContentPane.add((Component)this.getJButton2(), gridBagConstraints9);
            this.jContentPane.add((Component)this.jLabel3, gridBagConstraints10);
            this.jContentPane.add((Component)this.jLabel4, gridBagConstraints11);
            this.jContentPane.add((Component)this.jLabel5, gridBagConstraints12);
            this.jContentPane.add((Component)this.jLabel6, gridBagConstraints13);
            this.jContentPane.add((Component)this.getJTextField3(), gridBagConstraints14);
            this.jContentPane.add((Component)this.getJButton3(), gridBagConstraints15);
            this.jContentPane.add((Component)this.getJProgressBar(), gridBagConstraints16);
            this.jContentPane.add((Component)this.jLabel7, gridBagConstraints17);
            this.jContentPane.add((Component)this.getJButton4(), gridBagConstraints21);
            this.jContentPane.add((Component)this.jLabel8, gridBagConstraints31);
            this.jContentPane.add((Component)this.jLabel9, gridBagConstraints41);
            this.jContentPane.add((Component)this.jLabel10, gridBagConstraints51);
            this.jContentPane.add((Component)this.jLabel11, gridBagConstraints6);
            this.jContentPane.add((Component)this.getJTextField4(), gridBagConstraints71);
            this.jContentPane.add((Component)this.jLabel12, gridBagConstraints81);
            this.jContentPane.add((Component)this.getJTextField5(), gridBagConstraints91);
            this.jContentPane.add((Component)this.getJTextField6(), gridBagConstraints101);
            this.jContentPane.add((Component)this.jLabel13, gridBagConstraints111);
            this.jContentPane.add((Component)this.jLabel14, gridBagConstraints121);
            this.jContentPane.add((Component)this.jLabel15, gridBagConstraints131);
            this.jContentPane.add((Component)this.jLabel16, gridBagConstraints141);
            this.jContentPane.add((Component)this.jLabel17, gridBagConstraints18);
            this.jContentPane.add((Component)this.getJTextField7(), gridBagConstraints22);
        }
        return this.jContentPane;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setToolTipText("The (training) data set to be loaded.");
        }
        return this.jTextField;
    }

    public void cancel() {
        this.dispose();
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("browse");
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPASDialog.this.chooseTrainingSet();
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Identify interactions");
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPASDialog.this.startInteractionSearch();
                }
            });
        }
        return this.jButton1;
    }

    public void asynchroneousFeedback(Schedule schedule, Replay replay) {
        GenerationIndex now = schedule.getCurrentTimeIndex();
        int currentGeneration = now.generation;
        int currentRun = now.run;
        this.jProgressBar.setValue(currentGeneration + (currentRun - 1) * this.generations);
    }

    public void simulationCompleted(Actions.Action lastProcessed) {
        this.jButton.setEnabled(true);
        this.jButton1.setEnabled(true);
        this.jButton2.setEnabled(true);
        this.jButton3.setEnabled(true);
        this.jButton4.setEnabled(false);
    }

    public void simulationException(Exception exc) {
    }

    public void synchroneousFeedback(Schedule activeSchedule, Replay replay) {
    }

    public void terminated(Actions.Action lastProcessedBeforeTermination) {
    }

    private JTextField getJTextField1() {
        if (this.jTextField1 == null) {
            this.jTextField1 = new JTextField();
            this.jTextField1.setText("1");
            this.jTextField1.setToolTipText("The number of independent runs.");
        }
        return this.jTextField1;
    }

    private JTextField getJTextField2() {
        if (this.jTextField2 == null) {
            this.jTextField2 = new JTextField();
            this.jTextField2.setText("10000");
            this.jTextField2.setToolTipText("The number of generations for each run.");
        }
        return this.jTextField2;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setText("Discriminate");
            this.jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPASDialog.this.startDiscrimination();
                }
            });
        }
        return this.jButton2;
    }

    private void chooseTestSet() {
        final JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(".//data"));
        SingleExtensionFileFilter ff = new SingleExtensionFileFilter("csv", "CSV Files");
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        chooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (chooser.getSelectedFile() != null) {
                    GPASDialog.this.testFile = chooser.getSelectedFile();
                }
                if (GPASDialog.this.testFile != null) {
                    GPASDialog.this.jTextField3.setText(GPASDialog.this.testFile.getPath());
                }
            }
        });
        chooser.showOpenDialog(this);
        chooser.getSelectedFile();
    }

    private void chooseTrainingSet() {
        final JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(".//data"));
        SingleExtensionFileFilter ff = new SingleExtensionFileFilter("csv", "CSV Files");
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        chooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (chooser.getSelectedFile() != null) {
                    GPASDialog.this.dataFile = chooser.getSelectedFile();
                }
                if (GPASDialog.this.dataFile != null) {
                    GPASDialog.this.jTextField.setText(GPASDialog.this.dataFile.getPath());
                }
            }
        });
        chooser.showOpenDialog(this);
        chooser.getSelectedFile();
    }

    private void startDiscrimination() {
        Vector<String> errors = new Vector<String>();
        try {
            new FileReader(this.jTextField.getText());
        }
        catch (IOException e) {
            errors.add("\"" + this.jTextField.getText() + "\" is not a valid path to a data set.");
        }
        try {
            this.runs = Integer.parseInt(this.jTextField1.getText());
        }
        catch (NumberFormatException e) {
            errors.add("\"" + this.jTextField1.getText() + "\" is not a valid number of runs.");
        }
        try {
            this.generations = Integer.parseInt(this.jTextField2.getText());
        }
        catch (NumberFormatException e) {
            errors.add("\"" + this.jTextField2.getText() + "\" is not a valid number of generations.");
        }
        try {
            if (!this.jTextField3.getText().equals("")) {
                new FileReader(this.jTextField3.getText());
            }
        }
        catch (IOException e) {
            errors.add("\"" + this.jTextField3.getText() + "\" is not a valid path to a test data set.");
        }
        if (this.jTextField7.getText().trim().equals("")) {
            errors.add("You have to specify a file to save the result to.");
        }
        if (errors.size() > 0) {
            StringBuffer strbuf = new StringBuffer();
            Iterator errit = errors.iterator();
            while (errit.hasNext()) {
                strbuf.append((String)errit.next());
                if (!errit.hasNext()) continue;
                strbuf.append("\n");
            }
            JOptionPane.showMessageDialog(this, strbuf.toString());
        } else {
            this.jProgressBar.setMinimum(0);
            this.jProgressBar.setMaximum(this.generations * this.runs);
            this.jButton.setEnabled(false);
            this.jButton1.setEnabled(false);
            this.jButton2.setEnabled(false);
            this.jButton3.setEnabled(false);
            this.jButton4.setEnabled(true);
            ScheduleConfigurator.setDiscrimination(this.jTextField.getText(), this.runs, this.generations, this.jTextField3.getText(), this.jTextField7.getText());
            Schedule schedule = ScheduleConfigurator.getCurrentSchedule();
            this.runControl = new RunControl(this);
            this.runControl.setNewSchedule(schedule);
            this.runControl.request(new Actions.StartAction());
        }
    }

    private void startInteractionSearch() {
        int occurences = 10;
        double ratio = 0.1;
        Vector<String> errors = new Vector<String>();
        try {
            new FileReader(this.jTextField.getText());
        }
        catch (IOException e) {
            errors.add("\"" + this.jTextField.getText() + "\" is not a valid path to a data set.");
        }
        try {
            this.runs = Integer.parseInt(this.jTextField1.getText());
        }
        catch (NumberFormatException e) {
            errors.add("\"" + this.jTextField1.getText() + "\" is not a valid number of runs.");
        }
        try {
            this.generations = Integer.parseInt(this.jTextField2.getText());
        }
        catch (NumberFormatException e) {
            errors.add("\"" + this.jTextField2.getText() + "\" is not a valid number of generations.");
        }
        try {
            occurences = Integer.parseInt(this.jTextField5.getText());
        }
        catch (NumberFormatException e) {
            errors.add("\"" + this.jTextField5.getText() + "\" is not a valid number of minimum occurences.");
        }
        try {
            ratio = Double.parseDouble(this.jTextField6.getText());
        }
        catch (NumberFormatException e) {
            errors.add("\"" + this.jTextField6.getText() + "\" is not a valid number for the minimal ratio.");
        }
        if (this.jTextField7.getText().trim().equals("")) {
            errors.add("You have to specify a file to save the result to.");
        }
        if (errors.size() > 0) {
            StringBuffer strbuf = new StringBuffer();
            Iterator errit = errors.iterator();
            while (errit.hasNext()) {
                strbuf.append((String)errit.next());
                if (!errit.hasNext()) continue;
                strbuf.append("\n");
            }
            JOptionPane.showMessageDialog(this, strbuf.toString());
        } else {
            this.jProgressBar.setMinimum(0);
            this.jProgressBar.setMaximum(this.generations * this.runs);
            this.jButton.setEnabled(false);
            this.jButton1.setEnabled(false);
            this.jButton2.setEnabled(false);
            this.jButton3.setEnabled(false);
            this.jButton4.setEnabled(true);
            ScheduleConfigurator.setInteraction(this.jTextField.getText(), this.runs, this.generations, this.jTextField4.getText(), occurences, ratio, this.jTextField7.getText());
            Schedule schedule = ScheduleConfigurator.getCurrentSchedule();
            this.runControl = new RunControl(this);
            this.runControl.setNewSchedule(schedule);
            this.runControl.request(new Actions.StartAction());
        }
    }

    private JTextField getJTextField3() {
        if (this.jTextField3 == null) {
            this.jTextField3 = new JTextField();
            this.jTextField3.setToolTipText("Test data set if the training result should be tested on one.");
        }
        return this.jTextField3;
    }

    private JButton getJButton3() {
        if (this.jButton3 == null) {
            this.jButton3 = new JButton();
            this.jButton3.setText("browse");
            this.jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPASDialog.this.chooseTestSet();
                }
            });
        }
        return this.jButton3;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
        }
        return this.jProgressBar;
    }

    private JButton getJButton4() {
        if (this.jButton4 == null) {
            this.jButton4 = new JButton();
            this.jButton4.setText("abort");
            this.jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPASDialog.this.runControl.request(new Actions.TerminateAction());
                    GPASDialog.this.jButton.setEnabled(true);
                    GPASDialog.this.jButton1.setEnabled(true);
                    GPASDialog.this.jButton2.setEnabled(true);
                    GPASDialog.this.jButton3.setEnabled(true);
                    GPASDialog.this.jButton4.setEnabled(false);
                    GPASDialog.this.jProgressBar.setValue(0);
                }
            });
        }
        return this.jButton4;
    }

    private JTextField getJTextField4() {
        if (this.jTextField4 == null) {
            this.jTextField4 = new JTextField();
            this.jTextField4.setText("interactions.dot");
            this.jTextField4.setToolTipText("The name of the GraphViz file where the interaction graph should be saved in.");
        }
        return this.jTextField4;
    }

    private JTextField getJTextField5() {
        if (this.jTextField5 == null) {
            this.jTextField5 = new JTextField();
            this.jTextField5.setText("10");
            this.jTextField5.setToolTipText("The minimum number of times an interaction has to occur to be included in the interaction graph.");
        }
        return this.jTextField5;
    }

    private JTextField getJTextField6() {
        if (this.jTextField6 == null) {
            this.jTextField6 = new JTextField();
            this.jTextField6.setText("0.1");
            this.jTextField6.setToolTipText("The minimal ratio a single literal has to occur in relation to his ancestor in the interaction graph to be included in the interaction graph.");
        }
        return this.jTextField6;
    }

    private JTextField getJTextField7() {
        if (this.jTextField7 == null) {
            this.jTextField7 = new JTextField();
            this.jTextField7.setText("individuals.csv");
            this.jTextField7.setToolTipText("The file where the resulting models will be saved in.");
        }
        return this.jTextField7;
    }
}

