/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.module.fitness.pointset.AbstractRobustRegressionFitness;
import freak.module.fitness.pointset.util.ResidualContainer;
import freak.module.operator.mutation.common.vglSignedResiduals;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.PointSet;
import java.util.Arrays;

public class LTSMutation
extends Mutation
implements CompatibleWithDifferentSearchSpaces,
Configurable {
    AbstractRobustRegressionFitness m_kFitnessFunktion;
    double percentMovement = 2.0;

    public LTSMutation(OperatorGraph graph) {
        super(graph);
    }

    protected Individual doMutation(Individual ind) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int dimension = ((BitString)this.graph.getSchedule().getGenotypeSearchSpace()).getDimension();
        int pointDimension = ((PointSet)this.graph.getSchedule().getPhenotypeSearchSpace()).getPointDimension();
        BitStringGenotype bs = (BitStringGenotype)((BitStringGenotype)ind.getGenotype()).clone();
        ResidualContainer[] residuals = this.m_kFitnessFunktion.m_hResiduals;
        if (residuals == null) {
            int i = 0;
            while (i < bs.size()) {
                bs.set(i, false);
                ++i;
            }
            int j = 0;
            while (j < pointDimension) {
                int r = re.choose(0, dimension - 1);
                while (bs.get(r)) {
                    r = re.choose(0, dimension - 1);
                }
                bs.set(r, true);
                ++j;
            }
            return new Individual(this.graph.getSchedule(), bs, new Individual[]{ind});
        }
        int r = re.choose(0, dimension - 1);
        while (bs.get(r)) {
            r = re.choose(0, dimension - 1);
        }
        if (re.uniform(1.0, 100.0) <= this.percentMovement) {
            Arrays.sort(residuals, new vglSignedResiduals());
            if (r < pointDimension) {
                r = pointDimension;
            }
            int i = 0;
            while (i < dimension) {
                bs.set(i, false);
                ++i;
            }
            i = 0;
            while (i < pointDimension) {
                bs.set(residuals[r - i].pointIndexInPointSet, true);
                ++i;
            }
        } else {
            int s = re.choose(0, dimension - 1);
            while (!bs.get(s)) {
                s = re.choose(0, dimension - 1);
            }
            bs.set(s, false);
            bs.set(r, true);
        }
        return new Individual(this.graph.getSchedule(), bs, new Individual[]{ind});
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof AbstractRobustRegressionFitness) || !(schedule.getGenotypeSearchSpace() instanceof BitString)) {
            throw new UnsupportedEnvironmentException();
        }
        this.m_kFitnessFunktion = (AbstractRobustRegressionFitness)schedule.getRealFitnessFunction();
    }

    public String getDescription() {
        return "Mutation designed for LtSOptimization";
    }

    public void setPropertyPercentMovement(Double movement) {
        this.percentMovement = movement;
    }

    public Double getPropertyPercentMovement() {
        return new Double(this.percentMovement);
    }

    public String getName() {
        return "LTSMutation";
    }
}

