/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.graphedgeselection;

import freak.core.control.Schedule;
import freak.core.mapper.AbstractMapper;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionGenotype;
import java.util.ArrayList;

public class PruferNrMapper
extends AbstractMapper {
    private GeneralString genotypeSearchSpace;

    public PruferNrMapper(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        this.genotypeSearchSpace = new GeneralString(this.schedule);
        GraphEdgeSelection phenotypeSearchSpace = (GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace();
        int vertices = phenotypeSearchSpace.getPropertyNumberOfVertices();
        this.genotypeSearchSpace.setPropertyDimension(new Integer(vertices - 2));
        this.genotypeSearchSpace.setPropertyNumberOfChars(new Integer(vertices));
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        GraphEdgeSelection phenotypeSearchSpace = (GraphEdgeSelection)schedule.getPhenotypeSearchSpace();
        int vertices = phenotypeSearchSpace.getPropertyNumberOfVertices();
        if (phenotypeSearchSpace.getPropertyNumberOfEdges() != vertices * (vertices - 1) / 2) {
            throw new UnsupportedEnvironmentException();
        }
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.genotypeSearchSpace;
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        if (genotype == null) {
            return null;
        }
        GraphEdgeSelection ss = (GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace();
        GraphEdgeSelection.Graph graph = ss.getGraph();
        GraphEdgeSelectionGenotype gene = new GraphEdgeSelectionGenotype(graph);
        boolean[] edgeSelection = gene.getEdgeSelection();
        int[] pruferNr = ((GeneralStringGenotype)genotype).getIntArray();
        int[] lookupMap = new int[pruferNr.length + 2];
        int i = 0;
        while (i < pruferNr.length) {
            int n = pruferNr[i];
            lookupMap[n] = lookupMap[n] + 1;
            ++i;
        }
        int startAt = 0;
        int i2 = 0;
        while (i2 < pruferNr.length) {
            int j = startAt;
            while (j < graph.getNumberOfNodes() && lookupMap[j] != 0) {
                ++j;
            }
            int n = pruferNr[i2];
            lookupMap[n] = lookupMap[n] - 1;
            int n2 = j;
            lookupMap[n2] = lookupMap[n2] + 1;
            startAt = lookupMap[pruferNr[i2]] == 0 && pruferNr[i2] < j ? pruferNr[i2] : j + 1;
            edgeSelection[graph.findEdgeSelectionIndexForEdge((int)pruferNr[i2], (int)j)] = true;
            ++i2;
        }
        int node1 = startAt;
        while (node1 < graph.getNumberOfNodes() && lookupMap[node1] != 0) {
            ++node1;
        }
        int node2 = node1 + 1;
        while (node2 < graph.getNumberOfNodes() && lookupMap[node2] != 0) {
            ++node2;
        }
        edgeSelection[graph.findEdgeSelectionIndexForEdge((int)node1, (int)node2)] = true;
        gene.setEdgeSelection(edgeSelection);
        return gene;
    }

    public Genotype phenotypeToGenotype(Genotype phenotype) {
        if (phenotype == null) {
            return null;
        }
        GraphEdgeSelectionGenotype originalGraphGenotype = (GraphEdgeSelectionGenotype)phenotype;
        GraphEdgeSelection.Graph graph = originalGraphGenotype.getGraph();
        GraphEdgeSelectionGenotype graphGenotype = new GraphEdgeSelectionGenotype(graph);
        boolean[] edgeSelection = originalGraphGenotype.getEdgeSelection();
        boolean[] workEdgeSelection = new boolean[edgeSelection.length];
        int i = 0;
        while (i < edgeSelection.length) {
            workEdgeSelection[i] = edgeSelection[i];
            ++i;
        }
        graphGenotype.setEdgeSelection(workEdgeSelection);
        int[] pnum = new int[graph.getNumberOfNodes() - 2];
        int[] incidenceTable = new int[graph.getNumberOfNodes()];
        int i2 = 0;
        while (i2 < graph.getNumberOfNodes()) {
            incidenceTable[i2] = graph.getNumberOfSelectedIncidentEdgesForNode(i2, graphGenotype);
            ++i2;
        }
        int startAt = 0;
        int i3 = 0;
        while (i3 < pnum.length) {
            int j = startAt;
            while (j < graph.getNumberOfNodes() && incidenceTable[j] != 1) {
                ++j;
            }
            ArrayList edges = graph.getSelectedIncidentEdgesForNode(j, graphGenotype);
            GraphEdgeSelection.Graph.Edge edge = (GraphEdgeSelection.Graph.Edge)edges.get(0);
            pnum[i3] = edge.getEndNode();
            workEdgeSelection[edge.getIndexInGenotypeArray()] = false;
            int n = edge.getStartNode();
            incidenceTable[n] = incidenceTable[n] - 1;
            int n2 = edge.getEndNode();
            incidenceTable[n2] = incidenceTable[n2] - 1;
            ++i3;
        }
        GeneralStringGenotype gene = new GeneralStringGenotype(pnum, graph.getNumberOfNodes());
        return gene;
    }

    public String getName() {
        return "Edge Selection to Pr\u00b8fer Number";
    }

    public String getDescription() {
        return "This mapper works only on complete graphs. It performs a bijection between spanning-trees and a generalstring which represents the corresponding Pr\u00b8fer-number. The mapper works bidirectional.";
    }
}

