/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a modification of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 * Last modification: 06/28/2007
 */

package freak.gui.scheduleeditor;

import freak.core.modulesupport.*;
import freak.core.searchspace.*;
import freak.gui.*;

/**
 * @author  Oliver
 */
public class PanelSearchSpace extends ScheduleEditorPanel {

	/**
	 * @uml.property  name="searchSpaces"
	 * @uml.associationEnd  multiplicity="(0 -1)"
	 */
	private Module[] searchSpaces;

	/** Creates new JPanel */
	public PanelSearchSpace(ScheduleEditor scheduleEditor) {
		super(scheduleEditor);
		initComponents();
	}

	public static String getDescription() {
		return "Select Search Space";
	}

	protected void initForStartedSchedule() {
		listSearchspaces.setEnabled(false);
		buConfigSearchspace.setVisible(false);
	}

	public String getHelpURL() {
		return "node4.html#SECTION00441000000000000000";
	}

	public boolean mayAdvance() {
		return schedule.getPhenotypeSearchSpace() != null;
	}

	public void enter() {
		super.enter();
		searchSpaces = moduleCollector.getSearchSpaces();
		((ModuleList)listSearchspaces).setModules(searchSpaces, schedule.getPhenotypeSearchSpace());
	}

	private void parse() {
		Module m = schedule.getPhenotypeSearchSpace();
		Util.displayText(taDescrSearchspace, m.getDescription());
		if (m instanceof Configurable)
			Util.displayText(tfOptionsSearchspace, ((Configurable)m).getConfiguration().getDescription());
		else
			Util.displayText(tfOptionsSearchspace, "<not configurable>");
		buConfigSearchspace.setEnabled(m instanceof Configurable);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() { //GEN-BEGIN:initComponents
		java.awt.GridBagConstraints gridBagConstraints;

		jPanel1 = new javax.swing.JPanel();
		buConfigSearchspace = JButtonFactory.newButton();
		jLabel1 = new javax.swing.JLabel();
		jScrollPane5 = new javax.swing.JScrollPane();
		listSearchspaces = new ModuleList();
		jLabel2 = new javax.swing.JLabel();
		jScrollPane6 = new javax.swing.JScrollPane();
		taDescrSearchspace = new javax.swing.JTextArea();
		jLabel18 = new javax.swing.JLabel();
		tfOptionsSearchspace = new javax.swing.JTextField();

		setLayout(new java.awt.GridBagLayout());

		setBorder(new javax.swing.border.TitledBorder("Select Search Space"));
		jPanel1.setLayout(new java.awt.GridBagLayout());

		buConfigSearchspace.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
		buConfigSearchspace.setMnemonic('o');
		buConfigSearchspace.setText("Configure...");
		buConfigSearchspace.setEnabled(false);
		buConfigSearchspace.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				buConfigSearchspaceActionPerformed(evt);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		jPanel1.add(buConfigSearchspace, gridBagConstraints);

		jLabel1.setText("Options:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		jPanel1.add(jLabel1, gridBagConstraints);

		jScrollPane5.setMinimumSize(new java.awt.Dimension(220, 0));
		jScrollPane5.setPreferredSize(new java.awt.Dimension(220, 0));
		listSearchspaces.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
		listSearchspaces.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				listSearchspacesValueChanged(evt);
			}
		});

		jScrollPane5.setViewportView(listSearchspaces);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridheight = 3;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weighty = 0.1;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		jPanel1.add(jScrollPane5, gridBagConstraints);

		jLabel2.setText("Search Spaces:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		jPanel1.add(jLabel2, gridBagConstraints);

		taDescrSearchspace.setEditable(false);
		taDescrSearchspace.setLineWrap(true);
		taDescrSearchspace.setText("<no search space selected>");
		taDescrSearchspace.setWrapStyleWord(true);
		jScrollPane6.setViewportView(taDescrSearchspace);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.weighty = 0.1;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		jPanel1.add(jScrollPane6, gridBagConstraints);

		jLabel18.setText("Description:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(jLabel18, gridBagConstraints);

		tfOptionsSearchspace.setEditable(false);
		tfOptionsSearchspace.setText("<no search space selected>");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
		jPanel1.add(tfOptionsSearchspace, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.weighty = 0.1;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		add(jPanel1, gridBagConstraints);

	} //GEN-END:initComponents

	private void buConfigSearchspaceActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_buConfigSearchspaceActionPerformed
		String s = Util.configureModule(scheduleEditor, schedule.getPhenotypeSearchSpace(), schedule);
		if (s != null)
			Util.displayText(tfOptionsSearchspace, s);
		scheduleDependencyChecker.processNewModuleConfiguration(schedule.getGenotypeSearchSpace());
		scheduleEditor.updateComponents();
	} //GEN-LAST:event_buConfigSearchspaceActionPerformed

	private void listSearchspacesValueChanged(javax.swing.event.ListSelectionEvent evt) { //GEN-FIRST:event_listSearchspacesValueChanged
		if (evt.getValueIsAdjusting())
			return;
		SearchSpace oldObj = schedule.getPhenotypeSearchSpace();
		SearchSpace newObj = (SearchSpace)listSearchspaces.getSelectedValue();
		if (newObj != oldObj) {
			if (oldObj != null) {
				eventController.replaceGlobalEventSource(oldObj, newObj);
				eventController.removeModule(oldObj);
			}
			schedule.setPhenotypeSearchSpace(newObj);
			scheduleDependencyChecker.processNewSearchSpace();
			newObj.createEvents();
			scheduleEditor.updateComponents();
		}
		parse();
	} //GEN-LAST:event_listSearchspacesValueChanged

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton buConfigSearchspace;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel18;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JScrollPane jScrollPane5;
	private javax.swing.JScrollPane jScrollPane6;
	private javax.swing.JList listSearchspaces;
	private javax.swing.JTextArea taDescrSearchspace;
	private javax.swing.JTextField tfOptionsSearchspace;
	// End of variables declaration//GEN-END:variables

}
