/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.fitness.bitstring.SineCosine;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.BitSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SineCosineView
extends AbstractView
implements Configurable,
FreakSwingModel {
    private transient JPanel panel;
    private IndividualList individuals;
    private int n;

    public SineCosineView(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        this.n = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof SineCosine)) {
            throw new UnsupportedEnvironmentException("Does only work with the fitness function Sine Cosine.");
        }
    }

    public JPanel createPanel() {
        this.panel = new SineCosinePanel(this);
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object data) {
        super.update(data);
        SineCosineView sineCosineView = this;
        synchronized (sineCosineView) {
            this.individuals = (IndividualList)data;
        }
        UpdateManager.markDirty(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.panel == null) {
            return;
        }
        SineCosineView sineCosineView = this;
        synchronized (sineCosineView) {
            this.panel.repaint();
        }
    }

    public String getName() {
        return "SineCosine View";
    }

    public String getDescription() {
        return "The individuals in the population are represented as points on a circle.";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    public IndividualList getIndividualList() {
        return this.individuals;
    }

    private class SineCosinePanel
    extends JPanel {
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private SineCosineView view;
        private int START_POS = 7;

        public SineCosinePanel(SineCosineView view) {
            this.view = view;
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            int minDim = this.currentWidth < this.currentHeight ? this.currentWidth : this.currentHeight;
            this.graphics.drawOval(this.START_POS, this.START_POS, minDim, minDim);
            this.graphics.drawLine(this.START_POS + minDim / 2, 0, this.START_POS + minDim / 2, minDim + 15);
            this.graphics.drawLine(0, this.START_POS + minDim / 2, minDim + 15, this.START_POS + minDim / 2);
            this.graphics.setColor(Color.red);
            int prev_x = this.START_POS + minDim - 2;
            int prev_y = (int)((double)this.START_POS + (double)minDim / 2.0 - 2.0);
            int i = 0;
            while (i <= SineCosineView.this.n) {
                double x = (double)(minDim / 2) * Math.cos(Math.PI * 2 * (double)i / (double)SineCosineView.this.n);
                double y = (double)(-minDim / 2) * Math.sin(Math.PI * 2 * (double)i / (double)SineCosineView.this.n);
                int new_x = (int)((double)(this.START_POS + minDim / 2) + x) - 2;
                int new_y = (int)((double)(this.START_POS + minDim / 2) + y) - 2;
                this.graphics.fillOval(new_x, new_y, 5, 5);
                this.graphics.drawLine(prev_x, prev_y, new_x, new_y);
                prev_x = new_x;
                prev_y = new_y;
                ++i;
            }
            SineCosineView sineCosineView = this.view;
            synchronized (sineCosineView) {
                SineCosineView.this.individuals = this.view.getIndividualList();
                if (SineCosineView.this.individuals != null) {
                    Iterator it = SineCosineView.this.individuals.iterator();
                    while (it.hasNext()) {
                        this.drawIndividual((Individual)it.next(), minDim);
                    }
                }
            }
        }

        private void drawIndividual(Individual individual, int minDim) {
            BitSet bs = ((BitStringGenotype)individual.getGenotype()).getBitSet();
            int card = bs.cardinality();
            if (card == ((BitString)SineCosineView.this.getSchedule().getGenotypeSearchSpace()).getDimension()) {
                double x = (double)(minDim / 2) * Math.cos(Math.PI * 2 * (double)card / (double)SineCosineView.this.n);
                double y = (double)(-minDim / 2) * Math.sin(Math.PI * 2 * (double)card / (double)SineCosineView.this.n);
                int new_x = (int)((double)(this.START_POS + minDim / 2) + x) - 25;
                int new_y = (int)((double)(this.START_POS + minDim / 2) + y) - 8;
                this.graphics.setColor(Color.green);
                this.graphics.fillOval(new_x, new_y, 12, 12);
                return;
            }
            double x = (double)(minDim / 2) * Math.cos(Math.PI * 2 * (double)card / (double)SineCosineView.this.n);
            double y = (double)(-minDim / 2) * Math.sin(Math.PI * 2 * (double)card / (double)SineCosineView.this.n);
            int new_x = (int)((double)(this.START_POS + minDim / 2) + x) - 8;
            int new_y = (int)((double)(this.START_POS + minDim / 2) + y) - 8;
            this.graphics.setColor(Color.black);
            this.graphics.fillOval(new_x, new_y, 12, 12);
        }
    }
}

