/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.control.Schedule;
import freak.core.event.PortsChangedEventListener;
import freak.core.graph.FreakEdge;
import freak.core.graph.FreakPort;
import freak.core.graph.InPort;
import freak.core.graph.Operator;
import freak.core.graph.OperatorGraph;
import freak.core.graph.OperatorGraphCell;
import freak.core.graph.OutPort;
import freak.core.graph.Port;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;

public class FreakGraphModel
extends DefaultGraphModel
implements PortsChangedEventListener,
Serializable {
    Map operatorMapper = new HashMap();
    private OperatorGraph graph = null;

    public FreakGraphModel(OperatorGraph graph) {
        this.initializeFromGraph(graph);
        this.graph = graph;
    }

    public FreakGraphModel(Schedule schedule) {
        this.graph = new OperatorGraph(schedule);
        this.initializeFromGraph(this.graph);
        Map attributes = this.getAttributes(this.operatorMapper.get(this.graph.getStart()));
        attributes.put("bounds", new Rectangle(new Point(40, 10), new Dimension(100, 20)));
        attributes = this.getAttributes(this.operatorMapper.get(this.graph.getFinish()));
        attributes.put("bounds", new Rectangle(new Point(40, 250), new Dimension(100, 20)));
    }

    protected void initializeFromGraph(OperatorGraph graph) {
        Object[] toInsert = new OperatorGraphCell[graph.getOperatorCount()];
        HashMap<Port, FreakPort> portMapper = new HashMap<Port, FreakPort>();
        Hashtable<Serializable, Map> attributes = new Hashtable<Serializable, Map>();
        int i = 0;
        while (i < graph.getOperatorCount()) {
            Serializable currentOperator = graph.getOperator(i);
            toInsert[i] = new OperatorGraphCell((Operator)currentOperator);
            this.operatorMapper.put(currentOperator, toInsert[i]);
            currentOperator.setPortsChangedListener(this);
            Map map = ((DefaultGraphCell)toInsert[i]).getAttributes();
            attributes.put(currentOperator, map);
            Iterator ports = ((OperatorGraphCell)toInsert[i]).getPortIterator();
            while (ports.hasNext()) {
                FreakPort port = (FreakPort)ports.next();
                portMapper.put(port.getPort(), port);
            }
            ++i;
        }
        this.insert(toInsert, attributes, null, null, null);
        for (Serializable currentOperator : this.operatorMapper.values()) {
            Iterator ports = ((OperatorGraphCell)currentOperator).getPortIterator();
            while (ports.hasNext()) {
                FreakPort port = (FreakPort)ports.next();
                Port portModel = port.getPort();
                Iterator iter = portModel.getPartnerIterator();
                while (iter.hasNext()) {
                    Port partnerModel = (Port)iter.next();
                    FreakPort partner = (FreakPort)portMapper.get(partnerModel);
                    if (partner == null || !(partnerModel instanceof InPort)) continue;
                    ConnectionSet cs = new ConnectionSet();
                    FreakEdge edge = new FreakEdge(port, partner);
                    cs.connect((Object)edge, (Object)port, partner);
                    Map map = GraphConstants.createMap();
                    GraphConstants.setLineEnd(map, 2);
                    attributes = new Hashtable();
                    attributes.put(edge, map);
                    this.insert(new Object[]{edge}, attributes, cs, null, null);
                }
            }
        }
        this.refreshFloatingPorts();
    }

    public void remove(Object[] roots) {
        List<Object> toRemove = Arrays.asList(roots);
        toRemove = new Vector<Object>(toRemove);
        int i = 0;
        while (i < roots.length) {
            Object element = roots[i];
            if (element instanceof OperatorGraphCell) {
                OperatorGraphCell cell = (OperatorGraphCell)element;
                Vector edgesToRemove = new Vector();
                Iterator ports = cell.getPortIterator();
                while (ports.hasNext()) {
                    FreakPort port = (FreakPort)ports.next();
                    Iterator edges = port.edges();
                    while (edges.hasNext()) {
                        Object edge = edges.next();
                        edgesToRemove.add(edge);
                        if (!toRemove.contains(edge)) continue;
                        toRemove.remove(edge);
                    }
                }
                super.remove(edgesToRemove.toArray());
                this.operatorMapper.remove(cell.getOperator());
            } else if (element instanceof Port) {
                toRemove.remove(element);
            }
            ++i;
        }
        super.remove(toRemove.toArray());
    }

    protected Object[] handleInsert(Object[] cells) {
        if (cells == null) {
            return super.handleInsert(cells);
        }
        int i = 0;
        while (i < cells.length) {
            Object object = cells[i];
            if (object instanceof OperatorGraphCell) {
                OperatorGraphCell cell = (OperatorGraphCell)object;
                Operator operator = cell.getOperator();
                this.operatorMapper.put(operator, object);
                operator.setPortsChangedListener(this);
            }
            ++i;
        }
        return super.handleInsert(cells);
    }

    public void adjustLayout(JGraph graph) {
        CellView[] all = graph.getGraphLayoutCache().getAllDescendants(graph.getGraphLayoutCache().getRoots());
        int i = 0;
        while (i < all.length) {
            CellView view = all[i];
            if (view.getCell() instanceof OperatorGraphCell) {
                OperatorGraphCell cell = (OperatorGraphCell)view.getCell();
                Point point = ((Rectangle)cell.getAttributes().get("bounds")).getLocation();
                FontMetrics metrics = graph.getFontMetrics(graph.getFont());
                int height = metrics.getHeight();
                int width = metrics.stringWidth(cell.getOperator().toString());
                Dimension size = new Dimension(width + 10, height + 8);
                HashMap map = new HashMap();
                GraphConstants.setBounds(map, new Rectangle(point, size));
                cell.changeAttributes(map);
            }
            ++i;
        }
    }

    public boolean hasCircle(FreakPort source, FreakPort target) {
        HashSet visitedOperators = new HashSet();
        int i = 0;
        while (i < this.getRootCount()) {
            if (this.getRootAt(i) instanceof OperatorGraphCell && !visitedOperators.contains(this.getRootAt(i)) && this.hasCircle((OperatorGraphCell)this.getRootAt(i), new HashSet(), visitedOperators, source, target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasCircle(OperatorGraphCell operator, HashSet activeOperators, HashSet visitedOperators, FreakPort source, FreakPort target) {
        activeOperators.add(operator);
        visitedOperators.add(operator);
        int i = 0;
        while (i < operator.getChildCount()) {
            if (((FreakPort)operator.getChildAt(i)).getPort() instanceof OutPort) {
                FreakPort fPort = (FreakPort)operator.getChildAt(i);
                Iterator iter = fPort.edges();
                while (iter.hasNext()) {
                    FreakPort fTarget = (FreakPort)((Edge)iter.next()).getTarget();
                    if (activeOperators.contains(fTarget.getParent())) {
                        return true;
                    }
                    if (visitedOperators.contains(fTarget.getParent()) || !this.hasCircle((OperatorGraphCell)fTarget.getParent(), activeOperators, visitedOperators, source, target)) continue;
                    return true;
                }
                if (fPort == source) {
                    FreakPort fTarget = target;
                    if (activeOperators.contains(fTarget.getParent())) {
                        return true;
                    }
                    if (!visitedOperators.contains(fTarget.getParent()) && this.hasCircle((OperatorGraphCell)fTarget.getParent(), activeOperators, visitedOperators, source, target)) {
                        return true;
                    }
                }
            }
            ++i;
        }
        activeOperators.remove(operator);
        return false;
    }

    public void write(OutputStream s) throws IOException {
        Schedule schedule = this.graph.getSchedule();
        this.graph.setSchedule(null);
        new ObjectOutputStream(s).writeObject(this);
        this.graph.setSchedule(schedule);
    }

    public static FreakGraphModel read(InputStream s, Schedule schedule) throws IOException, ClassNotFoundException {
        return (FreakGraphModel)new ObjectInputStream(s).readObject();
    }

    public OperatorGraph getOperatorGraph() {
        return this.graph;
    }

    public void refreshFloatingPorts() {
        for (OperatorGraphCell cell : this.operatorMapper.values()) {
            cell.refreshFloatingPorts();
        }
    }

    public Map getOperatorMapper() {
        return this.operatorMapper;
    }

    public void portAdded(Operator source, Port port) {
        ((OperatorGraphCell)this.operatorMapper.get(source)).portAdded(port);
    }

    public void portRemoved(Operator source, Port port) {
        ((OperatorGraphCell)this.operatorMapper.get(source)).portRemoved(port);
    }

    public void portsExchanged(Operator source, Port port1, Port port2) {
        ((OperatorGraphCell)this.operatorMapper.get(source)).portsExchanged(port1, port2);
    }
}

