/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.observer.Observer;
import freak.core.view.HistoryView;
import freak.core.view.ObserverUnknownException;
import freak.core.view.swingsupport.FreakLargeTableModel;
import freak.core.view.swingsupport.FreakScrollBarAdjustmentListener;
import freak.core.view.swingsupport.FreakTableModel;
import freak.core.view.swingsupport.UpdateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Array;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class NumberTable
extends HistoryView
implements RunEventListener {
    private int maxNumberOfColumns;
    private FreakTableModel tableModel;
    private String measure;

    public NumberTable(Schedule schedule) {
        super(schedule);
        this.setPropertyNumberOfDisplayedValues(new Integer(0));
    }

    public String getName() {
        return "Number Table";
    }

    public String getDescription() {
        return "Displays the numbers in a table.";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{Number.class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class};
    }

    public JPanel createPanel() {
        JTable table = new JTable(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                Object data = this.getModel().getValueAt(row, column);
                return this.getDefaultRenderer(data.getClass());
            }
        };
        this.tableModel.setView(table);
        JPanel panel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(table);
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        scrollBar.addAdjustmentListener(new FreakScrollBarAdjustmentListener(scrollBar, true));
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object o) {
        super.update(o);
        try {
            FreakTableModel freakTableModel = this.tableModel;
            synchronized (freakTableModel) {
                double[] numbers = null;
                if (o instanceof Number) {
                    numbers = new double[]{((Number)o).doubleValue()};
                } else if (o.getClass().isArray()) {
                    int length = Array.getLength(o);
                    numbers = new double[length];
                    int i = 0;
                    while (i < length) {
                        numbers[i] = Array.getDouble(o, i);
                        ++i;
                    }
                }
                Object[] row = this.createRow(numbers, this.getCurrentValue());
                this.updateTableModel(row);
            }
            UpdateManager.markDirty(this.tableModel);
        }
        catch (ObserverUnknownException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object[] createRow(double[] numbers, int rowNumber) {
        if (numbers.length + 1 > this.maxNumberOfColumns) {
            this.maxNumberOfColumns = numbers.length + 1;
        }
        Object[] result = new Object[numbers.length + 1];
        result[0] = new Integer(rowNumber);
        int i = 0;
        while (i < numbers.length) {
            result[i + 1] = new Double(numbers[i]);
            ++i;
        }
        return result;
    }

    protected void updateTableModel(Object[] row) {
        if (this.tableModel.getColumnCount() < this.maxNumberOfColumns) {
            String[] columnNames = new String[this.maxNumberOfColumns];
            columnNames[0] = this.measure;
            int i = 1;
            while (i < columnNames.length) {
                columnNames[i] = String.valueOf(i);
                ++i;
            }
            this.tableModel.setColumnNames(columnNames);
        }
        if (this.getPropertyNumberOfDisplayedValues() > 0) {
            while (this.tableModel.getRowCount() >= this.getPropertyNumberOfDisplayedValues()) {
                this.tableModel.removeFirstRow();
            }
        }
        this.tableModel.addRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStarted(RunEvent evt) {
        super.runStarted(evt);
        if (this.getObserver().getMeasure() == 1) {
            FreakTableModel freakTableModel = this.tableModel;
            synchronized (freakTableModel) {
                this.tableModel.clear();
                this.maxNumberOfColumns = 1;
                String[] columnNames = new String[]{this.measure};
                this.tableModel.setColumnNames(columnNames);
            }
            UpdateManager.markDirty(this.tableModel);
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    public void setObserver(Observer observer) {
        super.setObserver(observer);
        if (this.getObserver() != null) {
            switch (this.getObserver().getMeasure()) {
                case 1: {
                    this.measure = "Generation";
                    break;
                }
                case 2: {
                    this.measure = "Run";
                    break;
                }
                case 3: {
                    this.measure = "Batch";
                }
            }
        }
        this.tableModel = new FreakLargeTableModel(new String[]{this.measure});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchStarted(BatchEvent evt) {
        super.batchStarted(evt);
        if (this.getObserver().getMeasure() == 2) {
            FreakTableModel freakTableModel = this.tableModel;
            synchronized (freakTableModel) {
                this.tableModel.clear();
                this.maxNumberOfColumns = 1;
                String[] columnNames = new String[]{this.measure};
                this.tableModel.setColumnNames(columnNames);
            }
            UpdateManager.markDirty(this.tableModel);
        }
    }
}

