/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class LongPathK
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int k = 1;

    public LongPathK(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if ((n - 1) % this.k != 0) {
            this.k = 1;
        }
    }

    private double pathPoint(BitSet set) {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int numberOfBlocks = (n - 1) / this.k;
        int pathPoint = set.get(n - 1) ? 2 : 1;
        int pathLength = 2;
        int i = numberOfBlocks - 1;
        while (i >= 0) {
            boolean oneBlock = false;
            int noZeros = 0;
            int j = i * this.k;
            while (j < (i + 1) * this.k) {
                boolean bit = set.get(j);
                if (!bit && oneBlock) {
                    return -1.0;
                }
                if (bit && !oneBlock) {
                    oneBlock = true;
                    noZeros = j - i * this.k;
                }
                ++j;
            }
            if (oneBlock && noZeros > 0) {
                if (pathPoint != pathLength) {
                    return -1.0;
                }
                pathPoint += this.k - noZeros;
            } else if (oneBlock && noZeros == 0) {
                pathPoint = this.k + 2 * pathLength - pathPoint;
            }
            pathLength = 2 * pathLength + this.k - 1;
            --i;
        }
        return pathPoint;
    }

    public double evaluate(Genotype genotype) {
        BitSet set = ((BitStringGenotype)genotype).getBitSet();
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        double pathPoint = this.pathPoint(set);
        if (pathPoint == -1.0) {
            int card = set.cardinality();
            int count = 0;
            int i = 0;
            while (i < this.k) {
                if (set.get(i)) {
                    ++count;
                }
                ++i;
            }
            return n * n - (n - 1) * count - card;
        }
        return (double)(n * n) + pathPoint;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int size = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        double sizeOfPath = (double)(this.k + 1) * Math.pow(2.0, (size - 1) / this.k) - (double)this.k + 1.0;
        return (double)(size * size) + sizeOfPath;
    }

    public double getLowerBound() throws UnsupportedOperationException {
        int size = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        return size * size * size - size * this.k - size - this.k - 1;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        BitSet bs = new BitSet(((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension());
        bs.set(0, this.k);
        bs.clear(this.k, ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension());
        return new BitStringGenotype(bs, ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension());
    }

    public void setPropertyK(Integer k) {
        if (k <= 0) {
            return;
        }
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if ((n - 1) % k == 0) {
            this.k = k;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForK() {
        return "The parameter k specifies the length and the construction of the path and has to be a factor of n-1. The length of the path is nearly 2^k. See the User's Guide for closer description.";
    }

    public String getDescription() {
        return "LongPathK contains a path with exponential length and strictly monotone fitness values. The length is nearly 2^k and thus exponential in the parameter k that is used to construct the path recursively.\nIndividuals on the path get fitness n^2 plus their index on the path.\nThe fitness value of all other individuals is n^2-OneMax, except that the first k Bits are stronger weighted (with weight n).";
    }

    public String getName() {
        return "LongPathK";
    }
}

