/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.graph;

import freak.core.graph.Operator;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.PropertyManager;
import freak.core.parametercontroller.ParameterController;
import freak.gui.CheckBoxDialog;
import freak.gui.JButtonFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PropertyChooser
extends JDialog {
    private Class paramType;
    private OperatorGraph operatorGraph;
    private static boolean parameterControllerDependencyWarningAcknowledged = false;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private PropertyWrapper returnProperty = null;
    private ParameterController parameterController = null;
    private JButton buCancel;
    private JButton buOk;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTree treeProperties;

    public PropertyChooser(Dialog parent, ParameterController pc, Class paramType, OperatorGraph operatorGraph) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.initTree();
        this.parameterController = pc;
        this.paramType = paramType;
        this.operatorGraph = operatorGraph;
        this.buildPropertyTree();
    }

    private void initTree() {
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(renderer.getLeafIcon());
        renderer.setClosedIcon(renderer.getLeafIcon());
        renderer.setLeafIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.treeProperties.setCellRenderer(renderer);
        this.treeProperties.setRootVisible(false);
        this.treeProperties.setShowsRootHandles(true);
        this.treeProperties.getSelectionModel().setSelectionMode(1);
        this.treeProperties.setExpandsSelectedPaths(true);
        this.treeProperties.setModel(this.treeModel);
    }

    private void buildPropertyTree() {
        int numOperators = this.operatorGraph.getOperatorCount();
        int i = 0;
        while (i < numOperators) {
            Operator g = this.operatorGraph.getOperator(i);
            String[] propertyNames = g.getListOfPropertyNamesWithType(this.paramType);
            if (propertyNames.length > 0) {
                DefaultMutableTreeNode operatorNode = new DefaultMutableTreeNode(g);
                this.treeModel.insertNodeInto(operatorNode, this.rootNode, this.rootNode.getChildCount());
                int j = 0;
                while (j < propertyNames.length) {
                    PropertyWrapper pw = new PropertyWrapper(g, propertyNames[j]);
                    DefaultMutableTreeNode propNode = new DefaultMutableTreeNode(pw);
                    operatorNode.add(propNode);
                    ++j;
                }
                Enumeration<TreeNode> children = operatorNode.children();
                while (children.hasMoreElements()) {
                    TreePath path = new TreePath(((DefaultMutableTreeNode)children.nextElement()).getPath());
                    this.treeProperties.setSelectionPath(path);
                }
            }
            this.treeProperties.setSelectionPath(null);
            ++i;
        }
    }

    public Operator getOperator() {
        if (this.returnProperty != null) {
            return this.returnProperty.owner;
        }
        return null;
    }

    public String getPropertyName() {
        if (this.returnProperty != null) {
            return this.returnProperty.propertyName;
        }
        return null;
    }

    private void checkParameterControllerDependencies(ParameterController myController, Operator operator, String propName) {
        if (!parameterControllerDependencyWarningAcknowledged) {
            List concurrentControllers = operator.getOperatorGraph().getParameterControllersForProperty(operator, propName);
            concurrentControllers.remove(myController);
            if (concurrentControllers.size() > 0) {
                ParameterController[] controllers = new ParameterController[concurrentControllers.size()];
                concurrentControllers.toArray(controllers);
                Arrays.sort(controllers, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (!(o1 instanceof ParameterController) || !(o2 instanceof ParameterController)) {
                            return 0;
                        }
                        return ((ParameterController)o1).getName().compareTo(((ParameterController)o2).getName());
                    }
                });
                String descr = PropertyManager.getShortDescriptionFor(operator, propName);
                StringBuffer s = new StringBuffer("The property " + descr + " is already controlled by the following parameter controller" + (controllers.length > 1 ? "s" : "") + ":\n");
                int i = 0;
                while (i < controllers.length) {
                    s.append("\n    " + controllers[i].getName());
                    ++i;
                }
                s.append("\n\nAdding multiple controllers to the same property might cause unpredictable results.");
                CheckBoxDialog dialog = new CheckBoxDialog(null, true, s.toString(), "Warning", "don't show this warning again");
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                parameterControllerDependencyWarningAcknowledged = dialog.isCheckBoxSelected();
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.treeProperties = new JTree();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.buOk = JButtonFactory.newButton();
        this.buCancel = JButtonFactory.newButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PropertyChooser.this.closeDialog(evt);
            }
        });
        this.treeProperties.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                PropertyChooser.this.treePropertiesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.treeProperties);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText("Select the property you want to control.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.buOk.setMnemonic('o');
        this.buOk.setText("OK");
        this.buOk.setEnabled(false);
        this.buOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyChooser.this.buOkActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buOk);
        this.buCancel.setText("Cancel");
        this.buCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyChooser.this.buCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void treePropertiesValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeProperties.getLastSelectedPathComponent();
        this.buOk.setEnabled(node != null && node.isLeaf());
    }

    private void buOkActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeProperties.getLastSelectedPathComponent();
        if (node.isLeaf()) {
            this.returnProperty = (PropertyWrapper)node.getUserObject();
            this.checkParameterControllerDependencies(this.parameterController, this.returnProperty.owner, this.returnProperty.propertyName);
        }
        this.closeDialog(null);
    }

    private void buCancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class PropertyWrapper {
        Operator owner;
        String propertyName;
        String propertyDescription;

        public PropertyWrapper(Operator owner, String propertyName) {
            this.owner = owner;
            this.propertyName = propertyName;
            this.propertyDescription = PropertyManager.getShortDescriptionFor(owner, propertyName);
            if (this.propertyDescription == null) {
                this.propertyDescription = propertyName;
            }
        }

        public String toString() {
            return this.propertyDescription;
        }
    }
}

