% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piall.R
\name{piall}
\alias{piall}
\title{Prediction intervals with all methods}
\usage{
piall(
  formula,
  traindata,
  testdata,
  alpha = 0.05,
  num.trees = 2000,
  mtry = ceiling(px/3)
)
}
\arguments{
\item{formula}{Object of class \code{formula} or \code{character} describing
the model to fit.}

\item{traindata}{Training data of class \code{data.frame}.}

\item{testdata}{Test data of class \code{data.frame}.}

\item{alpha}{Confidence level. (1 - \code{alpha}) is the desired coverage
level. The default is \code{alpha} = 0.05 for the 95\% prediction interval.}

\item{num.trees}{Number of trees. The default is \code{num.trees} = 2000}

\item{mtry}{Number of variables randomly selected as candidates for splitting
a node. The default is rounded up \eqn{px/3} where \eqn{px} is the number
of variables.}
}
\value{
A list with the following components:

\item{PIBF}{Prediction intervals for test data with PIBF method. A list
containing lower and upper bounds.}
\item{LS_LM}{Prediction intervals for test data with least-squares (LS)
splitting rule and classical method (LM). A list containing lower and upper
bounds.}
\item{LS_SPI}{Prediction intervals for test data with least-squares (LS)
splitting rule and shortest PI (SPI) method. A list containing lower and
upper bounds.}
\item{LS_Quant}{Prediction intervals for test data with least-squares (LS)
splitting rule and quantiles method. A list containing lower and upper
bounds.}
\item{LS_HDR}{Prediction intervals for test data with least-squares (LS)
splitting rule and highest density region (HDR) method. A list containing
lower and upper bounds of prediction interval for each test observation.
There may be multiple PIs for a single observation.}
\item{LS_CHDR}{Prediction intervals for test data with least-squares (LS)
splitting rule and contiguous HDR method. A list containing lower and upper
bounds.}
\item{L1_LM}{Prediction intervals for test data with \eqn{L_1} splitting
rule and classical method (LM). A list containing lower and upper bounds.}
\item{L1_SPI}{Prediction intervals for test data with \eqn{L_1} splitting
rule and shortest PI (SPI) method. A list containing lower and upper
bounds.}
\item{L1_Quant}{Prediction intervals for test data with \eqn{L_1} splitting
rule and quantiles method. A list containing lower and upper bounds.}
\item{L1_HDR}{Prediction intervals for test data with \eqn{L_1} splitting
rule and highest density region (HDR) method. A list containing lower and
upper bounds of prediction interval for each test observation. There may be
multiple PIs for a single observation.}
\item{L1_CHDR}{Prediction intervals for test data with \eqn{L_1} splitting
rule and contiguous HDR method. A list containing lower and upper bounds.}
\item{SPI_LM}{Prediction intervals for test data with shortest PI (SPI)
splitting rule and classical method (LM). A list containing lower and upper
bounds.}
\item{SPI_SPI}{Prediction intervals for test data with shortest PI (SPI)
splitting rule and shortest PI (SPI) method. A list containing lower and
upper bounds.}
\item{SPI_Quant}{Prediction intervals for test data with shortest PI (SPI)
splitting rule and quantiles method. A list containing lower and upper
bounds.}
\item{SPI_HDR}{Prediction intervals for test data with shortest PI (SPI)
splitting rule and highest density region (HDR) method. A list containing
lower and upper bounds of prediction interval for each test observation.
There may be multiple PIs for a single observation.}
\item{SPI_CHDR}{Prediction intervals for test data with shortest PI (SPI)
splitting rule and contiguous HDR method. A list containing lower and upper
bounds.}
\item{pred_pibf}{Bias-corrected random forest predictions for test data.}
\item{pred_ls}{Random forest predictions for test data with least-squares
(LS) splitting rule.}
\item{pred_l1}{Random forest predictions for test data with \eqn{L_1}
splitting rule.}
\item{pred_spi}{Random forest predictions for test data with shortest PI
(SPI) splitting rule.}
\item{test_response}{If available, true response values of the test data.
Otherwise, \code{NULL}.}
}
\description{
Constructs prediction intervals with the 16 methods (PIBF method implemented
in \code{pibf()} and 15 method variations implemented in \code{rfpi()}).
}
\examples{
\donttest{
## load example data
data(BostonHousing, package = "RFpredInterval")
set.seed(2345)

## define train/test split
testindex <- 1
trainindex <- sample(2:nrow(BostonHousing), size = 50, replace = FALSE)
traindata <- BostonHousing[trainindex, ]
testdata <- BostonHousing[testindex, ]

## construct 95\% PI with 16 methods for the first observation in testdata
out <- piall(formula = medv ~ ., traindata = traindata,
  testdata = testdata, num.trees = 50)
}

}
\seealso{
\code{\link{pibf}} \code{\link{rfpi}} \code{\link{plot.pi.piall}}
}
