% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my.test1fun.R
\name{my.test1fun}
\alias{my.test1fun}
\title{my.test1fun}
\usage{
my.test1fun(fn, start.arg, fix.arg, dpqr)
}
\arguments{
\item{fn}{\itemize{
\item name of the function to be tested "dsn", "psn" or "qsn"
}}

\item{start.arg}{\itemize{
\item the starting arguments for fitting the density
}}

\item{fix.arg}{\itemize{
\item fixed arguments
}}

\item{dpqr}{-- are we testing the "d", "p" or "q" function? not needed as it can be inferred from the argument "fn"}
}
\value{
fits the Density function for the skew-normal (SN) distribution.
}
\description{
tests the compliance of skew-normal distribution functions with the expectations
of the package fitdistrplus
}
\details{
RFlocalfdr also uses wrappers around the funcions dsn, qsn and psn from the package "sn"
https://cran.r-project.org/web/packages/sn/.
This is due to the fact that
fitdistrplus::fitdist(imp, "sn", start = list(xi = mean(imp)...
returns warnings such as
The dsn function should return a zero-length vector when input has length zero and not raise an error
The psn function should have its first argument named: q as in base R
These wrappers ensure conformity with the expectations of fitdistrplus::fitdist
}
\examples{
library(sn)
curve(sn::dsn(x,xi=0, omega=1, alpha=1, tau=0),xlim=c(-10,10),col="blue")
curve(sn::dsn(x,xi=0, omega=1, alpha=0.1, tau=0),xlim=c(-10,10),col="blue",add=TRUE)
curve(sn::dsn(x,xi=1, omega=2, alpha=2, tau=0),xlim=c(-10,20),col="blue",add=TRUE)
curve(sn::dsn(x,xi=3, omega=4, alpha=4, tau=0),xlim=c(-10,20),col="blue",add=TRUE)

curve(my.dsn(x),xlim=c(-10,10),col="red",add=TRUE)
curve(my.dsn(x,lambda=0.1),xlim=c(-10,10),col="red",add=TRUE)
curve(my.dsn(x,xi=1, omega=2, lambda=2),xlim=c(-10,20),col="red",add=TRUE)
curve(my.dsn(x,xi=3, omega=4, lambda=4),xlim=c(-10,20),col="red",add=TRUE)

#dsn, qsn and psn are wrappers around the provided functions provided by sn. This is done to
# overcome some checking done by fitdistrplus
\donttest{
library(sn)
getAnywhere("dsn")
RFlocalfdr::my.test1fun("sn::dsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))
RFlocalfdr::my.test1fun("sn::psn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))
RFlocalfdr::my.test1fun("sn::qsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))
#all return FALSE

detach("package:sn", unload=TRUE)
getAnywhere("dsn")
RFlocalfdr::my.test1fun("dsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))#TRUE
RFlocalfdr::my.test1fun("psn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))#TRUE
RFlocalfdr::my.test1fun("qsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))#TRUE
}
}
\keyword{normal}
\keyword{skew}
