% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_rendolatentIV.R
\name{predict.rendo.latent.IV}
\alias{predict.rendo.latent.IV}
\title{Predict method for Models using the Latent Instrumental Variables approach}
\usage{
\method{predict}{rendo.latent.IV}(object, newdata, ...)
}
\arguments{
\item{object}{Object of class inheriting from "rendo.latent.IV"}

\item{newdata}{An optional data frame in which to look for variables with which to predict.
If omitted, the fitted values are returned.}

\item{...}{ignored, for consistency with the generic function.}
}
\value{
\code{predict.rendo.latent.IV} produces a vector of predictions
}
\description{
Predicted values based on linear models estimated using the latent instrumental
variables approach for a single endogenous regressor.
}
\examples{
data("dataLatentIV")

lat  <- latentIV(y ~ P, data = dataLatentIV)

# returns the fitted values
predict(lat)

# using the data used for fitting also for predicting,
# correctly results in fitted values
all.equal(predict(lat, dataLatentIV), fitted(lat)) # TRUE

}
\seealso{
The model fitting function \code{\link[REndo:latentIV]{latentIV}}
}
