# TEST RUNABILITY ==================================================================================================================================================================

# Required data --------------------------------------------------------------------------------------------------------------------------------------------------------------------
# load from test/testthat folder
data("dataCopDis2")
data("dataCopCont")
data("dataCopCont2")
data("dataCopDisCont")

context("Runability - copulaCorrection - Runability")

test_that("Works with intercept", {
  # C1
  expect_warning(copulaCorrection(formula= y ~ X1+X2+P|continuous(P), verbose = FALSE, num.boots=2, data=dataCopCont),
                 regexp = "It is recommended to run more than", all = TRUE)
  # C2, Dis, DisCont
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1, P2), verbose = FALSE, data=dataCopCont2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(P1, P2),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1)+discrete(P2), verbose = FALSE, data=dataCopDisCont))
})

test_that("Works without intercept", {
  # C1
  expect_warning(copulaCorrection(formula= y ~ X1+X2+P-1|continuous(P), verbose = FALSE, num.boots=2, data=dataCopCont),
                 regexp = "It is recommended to run more than", all = TRUE)
  # C2, Dis, DisCont
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2-1|continuous(P1, P2), verbose = FALSE, data=dataCopCont2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2-1|discrete(P1, P2),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2-1|continuous(P1)+discrete(P2), verbose = FALSE, data=dataCopDisCont))
})


# Does not work because of the randomness - which ever is called first
# test_that("Same results with swapped endos", {
#   # C1 only has single endo, discont are fixed by type
#   expect_silent(res.c2.1  <- copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1, P2), verbose = FALSE, data=dataCopCont2))
#   expect_silent(res.dis.1 <- copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(P1, P2),   verbose = FALSE, data=dataCopDis2))
#
#   expect_silent(res.c2.2  <- copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P2, P1), verbose = T, data=dataCopCont2))
#   expect_silent(res.dis.2 <- copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(P2, P1),   verbose = T, data=dataCopDis2))
#
#   expect_setequal(coef(res.c2.1),  coef(res.c2.2))
#   expect_setequal(coef(res.dis.1), coef(res.dis.2))
# })

# test_that("No output when verbose = F", {
# })

# test_that("Warning and message when verbose = T", {
#
# })
#

# Too stable now :(
# test_that("Copula 1 fails gracefully for optimx crashes", {
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P|continuous(P), verbose=FALSE, data=dataCopCont,
#                                 start.params = c("(Intercept)"=2, X1=1.5,X2=1, P=-100)),
#                regexp = "Failed to optimize the log-likelihood function with error")
# })



test_that("Non-numerics can be used in exogenous data", {
  # factors + characters + logicals
  # C1
  expect_warning(copulaCorrection(formula= y ~ X1+X2+P+color|continuous(P), verbose = FALSE, num.boots=2,
                                 data=cbind(dataCopCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))),
                                    regexp = "It is recommended to run more than", all = TRUE)
  expect_warning(copulaCorrection(formula= y ~ X1+X2+P+color|continuous(P), verbose = FALSE, num.boots=2,
                                 data=cbind(dataCopCont,color=c("red", "green", "blue", "white", "yellow"))),
                                    regexp = "It is recommended to run more than", all = TRUE)
  expect_warning(copulaCorrection(formula= y ~ X1+X2+P+color|continuous(P), verbose = FALSE, num.boots=2,
                                 data=cbind(dataCopCont,color=c(TRUE,FALSE))),
                                  regexp = "It is recommended to run more than", all = TRUE)
  # C2
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|continuous(P1, P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|continuous(P1, P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=c("red", "green", "blue", "white", "yellow"))))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|continuous(P1, P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=c(TRUE,FALSE))))
  # Disc
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(P1, P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(P1, P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=c("red", "green", "blue", "white", "yellow"))))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(P1, P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=c(TRUE,FALSE))))
  # DiscCont
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(P1)+continuous(P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(P1)+continuous(P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=c("red", "green", "blue", "white", "yellow"))))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(P1)+continuous(P2), verbose = FALSE,
                                 data=cbind(dataCopDisCont,color=c(TRUE,FALSE))))
})


test_that("Start params work with non-numeric", {
  expect_warning(copulaCorrection(formula= y ~ X1+X2+P+color|continuous(P), verbose = FALSE, num.boots=2,
                                 data=cbind(dataCopCont,color=factor(x = c("red", "green", "blue", "white", "yellow"))),
                                 start.params = c("(Intercept)"=2, X1=1.5,X2=-3, P=-1,
                                                  colorgreen=-0.1, colorred=0, colorwhite=0, coloryellow=0)),
                 regexp = "It is recommended to run more than", all = TRUE)
})


# Transformations in formula ---------------------------------------------------------------------------------------------------
context("Runability - copulaCorrection - Formula transformations")
test_that("Works with function in exogenous", {
  # C1
  # ****TODO optimx warning bounds. Use elsewhere.
  # expect_warning(copulaCorrection(formula= y ~ exp(X1)+X2+P|continuous(P), verbose = FALSE, num.boots=2, data=dataCopCont),
  #                regexp = "It is recommended to run more than", all = TRUE)
  expect_warning(copulaCorrection(formula= y ~ I(X1/3)+X2+P|continuous(P), verbose = FALSE, num.boots=2, data=dataCopCont),
                                regexp = "It is recommended to run more than", all = TRUE)
  # C2, Dis, DisCont
  expect_silent(copulaCorrection(formula= y ~ exp(X1)+X2+P1+P2|continuous(P1, P2), verbose = FALSE, data=dataCopCont2))
  expect_silent(copulaCorrection(formula= y ~ exp(X1)+X2+P1+P2|discrete(P1, P2),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ exp(X1)+X2+P1+P2|continuous(P1)+discrete(P2), verbose = FALSE, data=dataCopDisCont))
})


test_that("Works with single endo transformation", {
  # C1
  expect_warning(copulaCorrection(formula= y ~ X1+X2+I(P/2)|continuous(I(P/2)), verbose = FALSE, num.boots=2, data=dataCopCont),
                 regexp = "It is recommended to run more than", all = TRUE)
  # C2, Dis, DisCont
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+I(P2/2)|continuous(P1, I(P2/2)), verbose = FALSE, data=dataCopCont2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+I(P2/2)|discrete(P1, I(P2/2)),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+I(P2/2)|continuous(P1)+discrete(I(P2/2)), verbose = FALSE, data=dataCopDisCont))
})


test_that("Works with transformed and untransformed endo", {
  # ***TODO: Use elsewhere: LM FAILURE!!
  # expect_warning(res.c1.1 <- copulaCorrection(formula= y ~ X1+X2+P+I(P/1.1)|continuous(I(P/1.1)), verbose = FALSE, num.boots=2, data=dataCopCont),
  #                regexp = "It is recommended to run more than", all = TRUE)
  # check that not the same are taken by comparing results

  # ****TODO: Ask raluca why they are not unequal?
  # C1
  # expect_warning(res.c1.1 <- copulaCorrection(formula= y ~ X1+X2+P+I(P/100)|continuous(I(P/100)), verbose = FALSE, num.boots=2, data=dataCopCont),
  #                regexp = "It is recommended to run more than", all = TRUE)
  # expect_warning(res.c1.2 <- copulaCorrection(formula= y ~ X1+X2+P+exp(P/100)|continuous(P), verbose = FALSE, num.boots=2, data=dataCopCont),
  #                regexp = "It is recommended to run more than", all = TRUE)
  # expect_false(isTRUE(all.equal(coef(res.c1.1), coef(res.c1.2))))

  # C2
  expect_silent(res.c2.1 <- copulaCorrection(formula= y ~ X1+X2+P1+P2+exp(P2/2)|continuous(P1, exp(P2/2)), verbose = FALSE, data=dataCopCont2))
  expect_silent(res.c2.2 <- copulaCorrection(formula= y ~ X1+X2+P1+P2+exp(P2/2)|continuous(P1, P2), verbose = FALSE, data=dataCopCont2))
  expect_false(isTRUE(all.equal(coef(res.c2.1), coef(res.c2.2))))

  #  Dis
  expect_silent(res.d1 <- copulaCorrection(formula= y ~ X1+X2+P1+P2+I(P2/2)|discrete(P1, I(P2/2)),   verbose = FALSE, data=dataCopDis2))
  expect_silent(res.d2 <- copulaCorrection(formula= y ~ X1+X2+P1+P2+I(P2/2)|discrete(P1, P2),   verbose = FALSE, data=dataCopDis2))
  expect_false(isTRUE(all.equal(coef(res.d1), coef(res.d2))))

  # DisCont
  expect_silent(res.cd1 <- copulaCorrection(formula= y ~ X1+X2+P1+P2+I(P2/2)|continuous(P1)+discrete(I(P2/2)), verbose = FALSE, data=dataCopDisCont))
  expect_silent(res.cd2 <- copulaCorrection(formula= y ~ X1+X2+P1+P2+I(P2/2)|continuous(P1)+discrete(P2), verbose = FALSE, data=dataCopDisCont))
  expect_false(isTRUE(all.equal(coef(res.cd1), coef(res.cd2))))
})

test_that("Works with all endo transformed", {
  # C1 done already in single because only has 1 endo
  # different endos
  expect_silent(copulaCorrection(formula= y ~ X1+X2+exp(P1)+I(P2/2)|continuous(exp(P1), I(P2/2)), verbose = FALSE, data=dataCopCont2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+exp(P1)+I(P2/2)|continuous(exp(P1), I(P2/2)),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+exp(P1)+I(P2/2)|discrete(exp(P1), I(P2/2)),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+exp(P1)+I(P2/2)|continuous(exp(P1))+discrete(I(P2/2)), verbose = FALSE, data=dataCopDisCont))
  # Same endos transformed twice
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+exp(P2)+I(P2/2)|continuous(exp(P2), I(P2/2)), verbose = FALSE, data=dataCopCont2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+exp(P2)+I(P2/2)|continuous(exp(P2), I(P2/2)),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+exp(P2)+I(P2/2)|discrete(exp(P2), I(P2/2)),   verbose = FALSE, data=dataCopDis2))
  expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+exp(P2)+I(P2/2)|continuous(exp(P2))+discrete(I(P2/2)), verbose = FALSE, data=dataCopDisCont))
})

test_that("start.params works with transformation", {
  expect_silent(copulaCorrection(start.params = c("(Intercept)"=2, X1 = 1.5, X2 = -3, "I(P + 1)" = -1),
                                 formula = y ~ X1 + X2 + I(P+1) |continuous(I(P+1)), data = dataCopCont, verbose=FALSE))
})

test_that("Correct for start.params swapped", {
  set.seed(0xcaffee)
  expect_silent(res.c1.1 <- copulaCorrection(start.params = c("(Intercept)"=2, X1 = 1.5, X2 = -3, "I(P + 1)" = -1),
                                 formula = y ~ X1 + X2 + I(P+1) |continuous(I(P+1)), data = dataCopCont, verbose=FALSE))
  set.seed(0xcaffee)
  expect_silent(res.c1.2 <- copulaCorrection(start.params = c(X2 = -3,"I(P + 1)" = -1, "(Intercept)"=2, X1 = 1.5),
                                 formula = y ~ X1 + X2 + I(P+1) |continuous(I(P+1)), data = dataCopCont, verbose=FALSE))

  # Equal, including param orderin
  expect_equal(coef(res.c1.1), coef(res.c1.2))
})



test_that("Transformations are correct", {

  # C2, Dis, DisCont
  set.seed(0xcaffee)
  expect_warning(correct.res.c1      <- copulaCorrection(formula= y ~ X1+X2+P|continuous(P), verbose = FALSE, num.boots=2, data=dataCopCont),
                 regexp = "It is recommended to run more than", all = TRUE)
  expect_silent(correct.res.c2      <- copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1, P2), verbose = FALSE, data=dataCopCont2))
  expect_silent(correct.res.dis     <- copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(P1, P2),   verbose = FALSE, data=dataCopDis2))
  expect_silent(correct.res.disCont <- copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1)+discrete(P2), verbose = FALSE, data=dataCopDisCont))

  # Can handle transformations in LHS
  set.seed(0xcaffee)
  # C1
  data.altered   <- dataCopCont
  data.altered$y <- exp(data.altered$y)
  expect_warning(res.trans.lhs  <- copulaCorrection(formula= log(y) ~ X1+X2+P|continuous(P), verbose = FALSE, num.boots=2, data=data.altered),
                 regexp = "It is recommended to run more than", all = TRUE)
  expect_equal(coef(res.trans.lhs), coef(correct.res.c1))
  expect_equal(coef(summary(res.trans.lhs)), coef(summary(correct.res.c1)))
  # C2
  data.altered   <- dataCopCont2
  data.altered$y <- exp(data.altered$y)
  expect_silent(res.trans.lhs      <- copulaCorrection(formula= log(y) ~ X1+X2+P1+P2|continuous(P1, P2), verbose = FALSE, data=data.altered))
  expect_equal(coef(res.trans.lhs), coef(correct.res.c2))
  expect_equal(coef(summary(res.trans.lhs)), coef(summary(correct.res.c2)))
  # Dis
  data.altered   <- dataCopDis2
  data.altered$y <- exp(data.altered$y)
  expect_silent(res.trans.lhs     <- copulaCorrection(formula= log(y) ~ X1+X2+P1+P2|discrete(P1, P2),   verbose = FALSE, data=data.altered))
  expect_equal(coef(res.trans.lhs), coef(correct.res.dis))
  expect_equal(coef(summary(res.trans.lhs)), coef(summary(correct.res.dis)))
  # DisCont
  data.altered   <- dataCopDisCont
  data.altered$y <- exp(data.altered$y)
  expect_silent(res.trans.lhs <- copulaCorrection(formula= log(y) ~ X1+X2+P1+P2|continuous(P1)+discrete(P2), verbose = FALSE, data=data.altered))
  expect_equal(coef(res.trans.lhs), coef(correct.res.disCont))
  expect_equal(coef(summary(res.trans.lhs)), coef(summary(correct.res.disCont)))

  # Can handle transformations in RHS1
  set.seed(0xcaffee)
  # C1
  data.altered    <- dataCopCont
  data.altered$P <- exp(data.altered$P)
  expect_warning(res.trans.rhs  <- copulaCorrection(formula= y ~ X1+X2+log(P)|continuous(log(P)), verbose = FALSE, num.boots=2, data=data.altered),
                 regexp = "It is recommended to run more than", all = TRUE)
  expect_equal(coef(res.trans.rhs), coef(correct.res.c1), check.attributes=FALSE)
  expect_equal(coef(summary(res.trans.rhs)), coef(summary(correct.res.c1)), check.attributes=FALSE)
  # C2
  data.altered    <- dataCopCont2
  data.altered$P2 <- exp(data.altered$P2)
  expect_silent(res.trans.rhs      <- copulaCorrection(formula= y ~ X1+X2+P1+log(P2)|continuous(P1, log(P2)), verbose = FALSE, data=data.altered))
  expect_equal(coef(res.trans.rhs), coef(correct.res.c2), check.attributes=FALSE)
  expect_equal(coef(summary(res.trans.rhs)), coef(summary(correct.res.c2)), check.attributes=FALSE)
  # Dis
  data.altered    <- dataCopDis2
  data.altered$P2 <- exp(data.altered$P2)
  expect_silent(res.trans.rhs   <- copulaCorrection(formula= y ~ X1+X2+P1+log(P2)|discrete(P1, log(P2)),   verbose = FALSE, data=data.altered))
  expect_equal(coef(res.trans.rhs), coef(correct.res.dis), check.attributes=FALSE)
  expect_equal(coef(summary(res.trans.rhs)), coef(summary(correct.res.dis)), check.attributes=FALSE)
  # Discont
  data.altered    <- dataCopDisCont
  data.altered$P2 <- exp(data.altered$P2)
  expect_silent(res.trans.rhs <- copulaCorrection(formula= y ~ X1+X2+P1+log(P2)|continuous(P1)+discrete(log(P2)), verbose = FALSE, data=data.altered))
  expect_equal(coef(res.trans.rhs), coef(correct.res.disCont), check.attributes=FALSE)
  expect_equal(coef(summary(res.trans.rhs)), coef(summary(correct.res.disCont)), check.attributes=FALSE)
})



# test_that("Works for multivar transformations",{
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1+P2),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1*P2),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(P1:P2),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(log(P1)),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|continuous(I(P1^2)),data=dataCopCont2), regexp = "The above errors were encountered!")
#
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(P1+P2),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(P1*P2),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(P1:P2),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(log(P1)),data=dataCopCont2), regexp = "The above errors were encountered!")
#   expect_error(copulaCorrection(formula= y ~ X1+X2+P1+P2|discrete(I(P1^2)),data=dataCopCont2), regexp = "The above errors were encountered!")
# })

# test_that("Factors can be used in endogenous data as discrete", {
#   # C1
#   expect_silent(copulaCorrection(formula= y ~ X1+X2+color|continuous(color), verbose = FALSE,
#                                  data=cbind(dataCopCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))))
#   # C2
#   # expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|continuous(P1, color), verbose = FALSE,
#                                  # data=cbind(dataCopDisCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))))
#   # Disc
#   expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(P1, color), verbose = FALSE,
#                                  data=cbind(dataCopDisCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))))
#   # DiscCont
#   expect_silent(copulaCorrection(formula= y ~ X1+X2+P1+P2+color|discrete(color)+continuous(P2), verbose = FALSE,
#                                  data=cbind(dataCopDisCont,color=factor(x = c("red", "green", "blue", "white", "yellow")))))
# })
