% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedGMM.R
\name{mixedGMM}
\alias{mixedGMM}
\title{Multilevel GMM Estimation}
\usage{
mixedGMM(formula, endoVar, data = NULL)
}
\arguments{
\item{formula}{an object of type 'formula': a symbolic description of the model to be fitted.}

\item{endoVar}{a matrix or data frame containing the variables assumed to be endogenous.}

\item{data}{optional data frame or list containing the variables of the model.}
}
\value{
returns the estimated coefficients together with their standard errors and p-values. It also returns the variance -covariance matrix and the weigth matrix used in estimation.
\item{coefficients}{the estimated coefficients.}
\item{coefSdErr}{the standard errors of the estimated coefficients.}
\item{vcovMat}{the variance-covariance matrix.}
\item{weigthMat}{the weight matrix used in estimation.}
\item{formula}{the formula of the estimated model.}
}
\description{
Estimates multilevel models (max. 3 levels) employing the GMM approach presented in Kim and Frees (2007). One of the important features is that, using the hierarchical 
structure of the data, no external instrumental variables are needed, unlike traditional instrumental variable techniques.
}
\details{
When all model variables are assumed exogenous the GMM estimator is the usual GLS estimator. 
While the GLS model assumes all explanatory variables are uncorrelated with the random intercepts and slopes in the model,
fixed effects models allow for endogeneity of all effects but sweeps out the random components as well as the explanatory variables at the same levels. 
The more general estimator presented here allows for some of the explanatory variables to be endogenous and uses this information to build internal instrumental variables.
The multilevel GMM estimator uses both the between and within variations of the exogenous variables, but only the within variation of the variables assumed 
endogenous. The mixed GMM estimator equals the random effects estimator when all variables are assumed exogenous and is equal to the fixed effects estimator 
when all variables are assumed endogenous. In between different GMM estimators are obtained for different sets of endogenous/exogenous variables.
}
\examples{
\dontrun{
data(tScores)
endoVars <- tScores[,5:7] 
formula <- 
TLI ~ GRADE_3 + RETAINED + SWITCHSC + S_FREELU + FEMALE + BLACK + HISPANIC + 
OTHER + C_COHORT + T_EXPERI + CLASS_SI + P_MINORI + 
(1+GRADE_3 | CID) + (1 | SID)
model1<- mixedGMM(formula, endoVars, data=tScores)
coef(model1)
}
}
\references{
Kim, Jee-Seon and Frees, Edward W. (2007). 'Multilevel Modeling with Correlated Effects'. \emph{Psychometrika},72(4), 505-533.
}
\author{
The implementation of the model formula by Raluca Gui based on the paper of Kim and Frees (2007).
}
\keyword{GMM}
\keyword{endogeneity}
\keyword{instrumental}
\keyword{instruments}
