/*
 * Decompiled with CFR 0.152.
 */
package ihm.graphique;

import ihm.controle.JPanelEA;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import util.GuiUtils;

public class CourbeIndice
extends JPanelEA {
    private float[] donnees;
    private int indiceFinDonnees;
    private String nomDonnees;
    private String nomIndice;
    private String nomMethode;
    private int indiceMin;
    private int indiceMax;
    private int indiceRunSelect;
    private int indiceRef;
    private boolean change;
    private float min;
    private float max;
    private int largeur;
    private int hauteur;
    private int marge_haut = 20;
    private int marge_gauche = 25;
    private int marge_bas = 17;
    private int marge_droite = 25;
    private int taille_point = 3;
    private int decal_point = (this.taille_point - 1) / 2;
    private int centre_y;

    public CourbeIndice(int l, int h) {
        this.largeur = l;
        this.hauteur = h;
        this.centre_y = this.hauteur - 1 - this.marge_bas;
        this.donnees = new float[500];
        this.indiceFinDonnees = -1;
        this.indiceMin = 0;
        this.indiceMax = -1;
        this.indiceRunSelect = 0;
        this.indiceRef = 0;
        this.change = false;
        this.setMinimumSize(new Dimension(this.largeur, this.hauteur));
        this.setPreferredSize(new Dimension(this.largeur, this.hauteur));
    }

    public int getMargeGauche() {
        return this.marge_gauche;
    }

    public int getMargeDroite() {
        return this.marge_droite;
    }

    public void raz() {
        this.indiceFinDonnees = -1;
        this.indiceMin = 0;
        this.indiceMax = -1;
        this.change = true;
    }

    public void setIndiceMinimum(int i) {
        this.indiceMin = i;
        this.change = true;
    }

    public void setIndiceMaximum(int i) {
        this.indiceMax = i;
        this.change = true;
    }

    public void setIndiceRunSelect(int i) {
        this.indiceRunSelect = i;
    }

    public void setIndiceReference(int i) {
        this.indiceRef = i;
    }

    public void setInfos(String nomDonnees, String nomIndice, String nomMethode) {
        this.nomDonnees = nomDonnees;
        this.nomIndice = nomIndice;
        this.nomMethode = nomMethode;
    }

    public void addNombre(float f) {
        int taille;
        if (this.indiceFinDonnees == -1) {
            this.min = f;
            this.max = f;
        }
        if (this.indiceFinDonnees == (taille = this.donnees.length) - 1) {
            int n_taille = taille * 120 / 100 + 1;
            float[] tab = this.donnees;
            this.donnees = new float[n_taille];
            System.arraycopy(tab, 0, this.donnees, 0, taille);
        }
        if (f > this.max) {
            this.max = f;
        } else if (f < this.min) {
            this.min = f;
        }
        this.donnees[++this.indiceFinDonnees] = f;
        this.indiceMax = this.indiceFinDonnees;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.largeur, this.hauteur);
        float echelleX = (float)(this.largeur - this.marge_gauche - this.marge_droite - this.taille_point) / (float)(this.indiceMax - this.indiceMin + 1);
        if (this.change) {
            this.min = this.donnees[this.indiceMax];
            this.max = this.donnees[this.indiceMax];
            for (int i2 = this.indiceMin; i2 < this.indiceMax; ++i2) {
                float f = this.donnees[i2];
                if (f > this.max) {
                    this.max = f;
                    continue;
                }
                if (!(f < this.min)) continue;
                this.min = f;
            }
            this.change = false;
        }
        float echelleY = (float)(this.hauteur - this.marge_bas - this.marge_haut - this.taille_point) / (this.max - this.min);
        g.setColor(Color.GRAY);
        g.setColor(Color.BLACK);
        g.drawLine(this.marge_gauche, this.centre_y, this.largeur - 1 - this.marge_droite, this.centre_y);
        int pas = 1;
        int nb = this.indiceMax - this.indiceMin + 1;
        if (nb >= 10) {
            pas = nb >= 20 ? nb / 10 : 2;
        }
        for (i = this.indiceMin; i <= this.indiceMax; ++i) {
            if ((i + 1) % pas != 0) continue;
            g.drawLine((int)((float)(i + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y, (int)((float)(i + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y + 3);
            g.drawString("" + (i + 1), (int)((float)(i + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y + 15);
        }
        g.drawLine(this.marge_gauche, this.marge_haut, this.marge_gauche, this.centre_y);
        g.drawLine(this.marge_gauche - 3, this.marge_haut, this.marge_gauche, this.marge_haut);
        g.drawLine(this.marge_gauche - 3, this.centre_y, this.marge_gauche, this.centre_y);
        g.drawString(GuiUtils.DECIMAL_2.format(this.max), this.marge_gauche + 4, this.marge_haut - 3);
        g.drawString(GuiUtils.DECIMAL_2.format(this.min), this.marge_gauche + 4, this.centre_y - 3);
        g.setColor(Color.BLUE);
        g.setFont(GuiUtils.FONT_PARAMETRE);
        g.drawLine((int)((float)(this.indiceRunSelect + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.marge_haut, (int)((float)(this.indiceRunSelect + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y);
        g.drawString("" + (this.indiceRunSelect + 1), (int)((float)(this.indiceRunSelect + 1 - this.indiceMin) * echelleX) + this.marge_gauche + 4, this.centre_y + 10);
        g.drawString("" + GuiUtils.DECIMAL_2.format(this.donnees[this.indiceRunSelect]), (int)((float)(this.indiceRunSelect + 1 - this.indiceMin) * echelleX) + this.marge_gauche + 4, this.hauteur - this.marge_bas - this.taille_point - (int)((this.donnees[this.indiceRunSelect] - this.min) * echelleY) - 3);
        g.setColor(Color.BLACK);
        for (i = this.indiceMin; i <= this.indiceMax; ++i) {
            g.fillRect((int)((float)(i + 1 - this.indiceMin) * echelleX) + this.marge_gauche - this.decal_point, this.hauteur - this.marge_bas - this.taille_point - (int)((this.donnees[i] - this.min) * echelleY) - this.decal_point, this.taille_point, this.taille_point);
        }
        if (this.indiceMin <= this.indiceRef && this.indiceRef <= this.indiceMax) {
            g.setColor(Color.RED);
            g.fillOval((int)((float)(this.indiceRef + 1 - this.indiceMin) * echelleX) + this.marge_gauche - 4, this.hauteur - this.marge_bas - this.taille_point - (int)((this.donnees[this.indiceRef] - this.min) * echelleY) - 4, 8, 8);
        }
    }
}

