% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_checkboxes.R
\name{combine_checkboxes}
\alias{combine_checkboxes}
\title{Combine Checkbox Fields into a Single Column}
\usage{
combine_checkboxes(
  supertbl,
  tbl,
  cols,
  names_prefix = "",
  names_sep = "_",
  names_glue = NULL,
  names_repair = "check_unique",
  multi_value_label = "Multiple",
  values_fill = NA,
  raw_or_label = "label",
  keep = TRUE
)
}
\arguments{
\item{supertbl}{A supertibble generated by \code{\link[=read_redcap]{read_redcap()}}. Required.}

\item{tbl}{The \code{redcap_form_name} of the data tibble to extract. Required.}

\item{cols}{Checkbox columns to combine to single column. Required.}

\item{names_prefix}{String added to the start of every variable name.}

\item{names_sep}{String to separate new column names from \code{names_prefix}.}

\item{names_glue}{Instead of \code{names_sep} and \code{names_prefix}, you can supply
a glue specification and the unique \code{.value} to create custom column names.}

\item{names_repair}{What happens if the output has invalid column names?
The default, "check_unique" is to error if the columns are duplicated.
Use "minimal" to allow duplicates in the output, or "unique" to de-duplicated
by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more options.}

\item{multi_value_label}{A string specifying the value to be used when multiple
checkbox fields are selected. Default "Multiple".}

\item{values_fill}{Value to use when no checkboxes are selected. Default \code{NA}.}

\item{raw_or_label}{Either 'raw' or 'label' to specify whether to use raw coded
values or labels for the options. Default 'label'.}

\item{keep}{Logical indicating whether to keep the original checkbox fields in
the output. Default \code{TRUE}.}
}
\value{
A modified supertibble.
}
\description{
\code{\link[=combine_checkboxes]{combine_checkboxes()}} consolidates multiple checkbox fields in a REDCap data
tibble into a single column. This transformation simplifies analysis by
merging several binary columns into one labeled factor column, making the
data more interpretable and easier to analyze.
}
\details{
\code{\link[=combine_checkboxes]{combine_checkboxes()}} operates on the data and metadata tibbles produced by
the \code{\link[=read_redcap]{read_redcap()}} function. Since it relies on the checkbox field naming
conventions used by REDCap, changes to the checkbox variable names or their
associated metadata \code{field_name}s could lead to errors.

REDCap checkbox fields are typically expanded into separate variables for each
checkbox option, with names formatted as \code{checkbox_var___1}, \code{checkbox_var___2},
etc. \code{\link[=combine_checkboxes]{combine_checkboxes()}} detects these variables and combines them into a
single column. If the expected variables are not found, an error is returned.
}
\examples{
# Set up sample data tibble
data_tbl <- tibble::tribble(
  ~"study_id", ~"multi___1", ~"multi___2", ~"multi___3",
  1, TRUE, FALSE, FALSE,
  2, TRUE, TRUE, FALSE,
  3, FALSE, FALSE, FALSE
)

# Set up sample metadata tibble
metadata_tbl <- tibble::tribble(
  ~"field_name", ~"field_type", ~"select_choices_or_calculations",
  "study_id", "text", NA,
  "multi___1", "checkbox", "1, Red | 2, Yellow | 3, Blue",
  "multi___2", "checkbox", "1, Red | 2, Yellow | 3, Blue",
  "multi___3", "checkbox", "1, Red | 2, Yellow | 3, Blue"
)

# Create sample supertibble
supertbl <- tibble::tribble(
  ~"redcap_form_name", ~"redcap_data", ~"redcap_metadata",
  "tbl", data_tbl, metadata_tbl
)

class(supertbl) <- c("redcap_supertbl", class(supertbl))

# Combine checkboxes under column "multi"
combine_checkboxes(
  supertbl = supertbl,
  tbl = "tbl",
  cols = starts_with("multi")
) |>
  dplyr::pull(redcap_data) |>
  dplyr::first()

\dontrun{

redcap_uri <- Sys.getenv("REDCAP_URI")
token <- Sys.getenv("REDCAP_TOKEN")

supertbl <- read_redcap(redcap_uri, token)
combine_checkboxes(
  supertbl = supertbl,
  tbl = "tbl",
  cols = starts_with("col"),
  multi_value_label = "Multiple",
  values_fill = NA
)
}

}
