% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_dictionary.R
\name{rd_dictionary}
\alias{rd_dictionary}
\title{Transform the data dictionary and handle branching logic}
\usage{
rd_dictionary(project = NULL, data = NULL, dic = NULL, event_form = NULL)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}
}
\value{
A list with the following elements:
\describe{
\item{data}{The original dataset passed to the function.}
\item{dictionary}{The updated data dictionary with modified branching logic and calculations.}
\item{event_form}{The original event-form mapping (if applicable).}
\item{results}{A summary of the transformations, including any variables with unconverted branching logic.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Updates a REDCap data dictionary by converting branching logic and calculation expressions into valid R expressions. This ensures that conditional display rules and calculated fields in the dictionary can be programmatically evaluated with the dataset. Any variables that cannot be converted are reported in the results.
}
\details{
The function performs the following tasks:
\itemize{
\item Evaluates and transforms branching logic expressions into valid R expressions using \code{rd_rlogic}.
\item Evaluates and converts calculation expressions for fields of type \code{calc}.
\item Generates a results summary table listing any variables that could not be converted.
}
}
\examples{
\dontrun{
result <- rd_dictionary(covican)
print(result$results)
updated_dic <- result$dictionary
}

}
