% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_queries.R
\name{check_queries}
\alias{check_queries}
\title{Check for changes between two reports of the queries}
\usage{
check_queries(old, new, report_title = NULL)
}
\arguments{
\item{old}{Previous version of the queries report.}

\item{new}{New version of the queries report. The status of each query is determined using this object.}

\item{report_title}{Character string specifying the title of the report.}
}
\value{
A list consisting of a dataframe with every single query of both reports and a column containing the status of the queries (new, solved, miscorrected or pending) compared to the previous query report. There is also a summary of the total number of queries per category in addition to this dataframe.
}
\description{
This function compares a previous report of queries with a new one and allows you to check which queries are new, which have been modified, and which remain unchanged.
}
\examples{
# Example of a query
data_old <- rd_query(covican,
                     variables = "copd",
                     expression = "\%in\%NA",
                     event = "baseline_visit_arm_1")
data_new <- rbind(data_old$queries[1:5,], c("100-20",rep("abc",8)))

# Control of queries
check <- check_queries(old = data_old$queries,
                       new = data_new)
}
