% Generated by roxygen2 (4.0.0): do not edit by hand
\name{control.rds.estimates}
\alias{control.rds.estimates}
\title{Auxiliary for Controlling RDS.bootstrap.intervals}
\usage{
control.rds.estimates(confidence.level = 0.95, SS.infinity = 0.01,
  useC = TRUE, number.of.bootstrap.samples = NULL, seed = NULL)
}
\arguments{
\item{confidence.level}{The confidence level for the confidence intervals.
The default is 0.95 for 95\%.}

\item{SS.infinity}{The sample proportion, \code{n/N}, below which the computation of the SS weights should simplify to that of the \code{RDS-II} weights.}

\item{useC}{Use a C-level implementation of Gile's bootstrap (rather than
the R level). The implementations should be computational
equivalent (except for speed).}

\item{number.of.bootstrap.samples}{The number of bootstrap samples to take
in estimating the uncertainty of the estimator. If \code{NULL} it defaults
to the number necessary to compute the standard error to accuracy 0.001.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning RDS.bootstrap.intervals algorithm,
which computes interval estimates for via bootstrapping.
}
\details{
This function is only used within a call to the \code{\link{RDS.bootstrap.intervals}}
function.

Some of the arguments are not yet fully implemented. It will evolve slower to incorporate more
arguments as the package develops.
}
\seealso{
\code{\link{RDS.bootstrap.intervals}}
}
\keyword{models}

