% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersectConicLine.R
\name{intersectConicLine}
\alias{intersectConicLine}
\title{Intersections between a conic and a line}
\source{
Richter-Gebert, Jürgen (2011). 
\emph{Perspectives on Projective Geometry - A Guided Tour Through Real
and Complex Geometry}, Springer, Berlin, ISBN: 978-3-642-17285-4
}
\usage{
intersectConicLine(C, l)
}
\arguments{
\item{C}{\eqn{(3 \times 3)} matrix representation of conics.}

\item{l}{a \eqn{(3 \times 3)} vector of the homogeneous representation of a line.}
}
\value{
The homogeneous coordinates of the intersection points. 
If there are two points of intersection, it returns a \eqn{(3 \times 2)} 
matrix whose columns correspond to the homogeneous coordinates of the 
intersection points. If there is only one point, a \eqn{(3 \times 1)} 
vector of the homogeneous coordinates of the intersection point is returned. 
If there is no intersection, \code{NULL} is returned.
}
\description{
Returns the point(s) of intersection between a conic and a line in homogeneous coordinates.
}
\examples{
#' # Ellipse with semi-axes a=8, b=2, centered in (0,0), with orientation angle = -pi/3
C <- ellipseToConicMatrix(c(8,2),c(0,0),-pi/3)

# line
l <- c(0.25,0.85,-3)

# intersection conic C with line l:
p_Cl <- intersectConicLine(C,l)

# plot
plot(ellipse(c(8,2),c(0,0),-pi/3),type="l",asp=1)
addLine(l,col="red")
points(t(p_Cl), pch=20,col="red")
}
