% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_parallel.R
\name{parallel_algorithm}
\alias{parallel_algorithm}
\title{Wrapper of the loop over the subsets which in turn use the parallelised algorithm.}
\usage{
parallel_algorithm(
  original_data,
  indices_subset,
  S_cand,
  k_cand,
  kg_cand,
  C_candidates,
  robust = TRUE,
  USE_DO = FALSE,
  choice_pic = "pic2022",
  maxit = 30
)
}
\arguments{
\item{original_data}{list containing the original data (1: Y, 2: X)}

\item{indices_subset}{vector with indices of the subsets; starts with zero}

\item{S_cand}{candidates for S (number of groups)}

\item{k_cand}{candidates for k (number of common factors)}

\item{kg_cand}{candidates for kg (number of group specific factors)}

\item{C_candidates}{candidates for C}

\item{robust}{robust or classical estimation}

\item{USE_DO}{(for testing purposes) if TRUE, then a serialized version is performed ("do" instead of "dopar")}

\item{choice_pic}{indicates which PIC to use to estimate the number of groups and factors.
Options are "pic2017" (PIC of \insertCite{Ando2017;textual}{RCTS}; works better for large N),
"pic2016" (\insertCite{Ando2016;textual}{RCTS}; works better for large T) weighs the fourth term with an extra factor relative to the size of the groups,
and "pic2022" which shrinks the NT-space where the number of groups and factors would be over- or underestimated compared to pic2016 and pic2017. This is the default.
This parameter can also be a vector with multiple pic's.}

\item{maxit}{maximum limit for the number of iterations for each configuration; defaults to 30}
}
\value{
Returns a list with three elements.
\enumerate{
\item Data.frame with the optimal number of common factors for each candidate C in the rows.
Each column contains the results of one subset of the input data (the first row corresponds to the full dataset).
\item Data.frame with the optimal number of groups and group specific factors for each candidate C in the rows. The structure is the same as in the above.
Each entry is of the form "1_2_3_NA". This is to be interpreted as 3 groups (three non NA values) where group 1 contains 1 group specific factor,
group 2 contains 2 and group 3 contains 3.
\item Data.frame with information about each configuration in the rows.
}
}
\description{
Wrapper of the loop over the subsets which in turn use the parallelised algorithm.
}
\examples{
\donttest{
#Using a small dataset as an example; this will generate several warnings due to its small size.
#Note that this example is run sequentially instead of parallel,
#  and consequently will print some intermediate information in the console.
#This example uses the classical algorithm instead of the robust algorithm
#  to limit its running time.
set.seed(1)
original_data <- create_data_dgp2(30, 10)
#define the number of subsets used to estimate the optimal number of groups and factors
indices_subset <- define_number_subsets(2)
#define the candidate values for C (this is a parameter in the information criterium
#  used to estimate the optimal number of groups and factors)
C_candidates <- define_C_candidates()

S_cand <- 3:3 # vector with candidate number of groups
k_cand <- 0:0 # vector with candidate number of common factors
kg_cand <- 1:2 # vector with candidate number of group specific factors

#excluding parallel part from this example
#cl <- makeCluster(detectCores() - 1)
#registerDoSNOW(cl)
output <- parallel_algorithm(original_data, indices_subset, S_cand, k_cand, kg_cand,
  C_candidates, robust = FALSE, USE_DO = TRUE, maxit = 3)
#stopCluster(cl)
}
}
