% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LinksMetrics.R
\name{link_Metrics_EncodersByCount}
\alias{link_Metrics_EncodersByCount}
\title{Returns users who have encoded this link.}
\usage{
link_Metrics_EncodersByCount(link, limit = 100, my_network = "false",
  expand_user = "false", subaccounts = "false", showRequestURL = FALSE)
}
\arguments{
\item{link}{- a Bitlink.}

\item{limit}{- 1 to 1000 (default=1000).}

\item{my_network}{- true or false (default) restrict to my network}

\item{expand_user}{- false (always default) include display names of encoders}

\item{subaccounts}{- (only available to enterprise accounts) false (always default) restrict to
this enterprise account and its subaccounts}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
entries - a mapping of link, user, and ts (when the Bitlink was created) and possible
more depending on input parameters.
}
\description{
Returns users who have encoded this link (optionally only those in the requesting
user's social graph), sorted by the number of clicks on each encoding user's link.
}
\note{
The response will only contain users whose links have gotten at least one click, and
will not contain any users whose links are private.
}
\examples{
rbitlyApi("0906523ec6a8c78b33f9310e84e7a5c81e500909")
link_Metrics_EncodersByCount(link = "http://bit.ly/DPetrov", my_network = "false", limit = 100)
link_Metrics_EncodersByCount(link = "http://bit.ly/DPetrov", my_network = "false", limit = 100,
expand_user = "true")
}
\seealso{
See \url{http://dev.bitly.com/link_metrics.html#v3_link_encoders_by_count}
}

