% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinaryExactCI.R
\name{BinaryExactCI}
\alias{BinaryExactCI}
\title{Exact Confidence interval for Binary Proportion}
\usage{
BinaryExactCI(r, n, alpha = 0.05, drop = TRUE)
}
\arguments{
\item{r}{Number of success or responder}

\item{n}{Sample size}

\item{alpha}{confidence level}

\item{drop}{Determines if \code{\link{drop}} will be called on the result}
}
\value{
100 (1-\eqn{\alpha})\% exact confidence interval for given
response rate
}
\description{
This function calculates the exact confidendence interval for a
response rate presented by \eqn{n} and \eqn{r}.
}
\details{
Confidence intervals are obtained by a procedure first given in 
Clopper and Pearson (1934). This guarantees that the confidence 
level is at least (1-\eqn{\alpha}).

Details can be found in the publication listed below.
}
\examples{
BinaryExactCI(3,20,0.05)

}
\references{
Clopper, C. J. & Pearson, E. S. The use of confidence or
fiducial limits illustrated in the case of the binomial. Biometrika 1934.
}
