#' Get number of cores
#' 
#' Get the number of cores available in the machine.
#' 
#' @references Jeroen Ooms (2013). The RAppArmor Package: Enforcing Security Policies in {R} Using Dynamic Sandboxing on Linux. \emph{Journal of Statistical Software}, 55(7), 1-34. \url{http://www.jstatsoft.org/v55/i07/}.
#' @references Ubuntu Manpage: \code{_SC_NPROCESSORS_ONLN} - \emph{The number of processors currently online (available)}. \url{http://manpages.ubuntu.com/manpages/precise/man3/sysconf.3.html}.
#' @export 
ncores <- function(){
	ret <- integer(1);
	output <- .C('ncores', ret, PACKAGE="RAppArmor");
	val <- output[[1]];
	if(val <= 0 ) stop("Failed to get number of cores. Try parallel:detectCores() instead");	
	return(val);
}