% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rah_subscription_info.R
\name{rah_subscription_info}
\alias{rah_subscription_info}
\title{Export user subscription information.}
\source{
\url{https://ahrefs.com/api/documentation}
}
\usage{
rah_subscription_info(target, token = Sys.getenv("AHREFS_AUTH_TOKEN"),
  mode = "domain", metrics = NULL, limit = 1000, order_by = NULL,
  where = NULL, having = NULL)
}
\arguments{
\item{target}{character string. Aim of a request: a domain, a directory or a URL}

\item{token}{character string. Authentication token. Should be available through enviromental variables
after authentication with function \code{rah_auth()}}

\item{mode}{character string. Mode of operation: exact, domain, subdomains or prefix. See more in Details section}

\item{metrics}{character vector of columns to select. See more in Details section}

\item{limit}{integer. Number of results to return}

\item{order_by}{character vector of columns to sort on. See more in Details section}

\item{where}{character string - a condition created by \code{rah_condition_set()} function that generates proper
\code{"where"} condition to satisfy. See more in Details section}

\item{having}{character string - a condition created by \code{rah_condition_set()} function that generates proper
\code{"having"} condition to satisfy. See more in Details section}
}
\value{
data frame
}
\description{
Export user subscription information.
}
\details{
\strong{1. available metrics} - you can select which columns (metrics) you want to download and which one
    would be useful in filtering, \strong{BUT not all of them can always be used} in \code{"where"} &
    \code{"having"} conditions:

    \tabular{lllll}{
    Column \tab Type \tab Where \tab Having \tab Description\cr
    rows_left    \tab int    \tab - \tab - \tab Number of rows available for making API requests.        \cr
    rows_limit   \tab int    \tab - \tab - \tab Total number of rows available for the subscription plan.\cr
    subscription \tab string \tab - \tab - \tab Name of the API subscription plan.
    }

    \strong{2. \code{"mode"}} parameter can take 4 different values that will affect how the results will be grouped.

Example of URL directory with folder:
    \itemize{
      \item \strong{Example URL:} ahrefs.com/api/
      \item \strong{exact:} ahrefs.com/api/
      \item \strong{domain:} ahrefs.com/*
      \item \strong{subdomains:} *ahrefs.com/*
      \item \strong{prefix:} ahrefs.com/api/*
    }
Example of URL directory with subdomain:
    \itemize{
      \item \strong{Example URL:} apiv2.ahrefs.com
      \item \strong{exact:} apiv2.ahrefs.com/
      \item \strong{domain:} apiv2.ahrefs.com/*
      \item \strong{subdomains:} *apiv2.ahrefs.com/*
      \item \strong{prefix:} apiv2.ahrefs.com/*
    }

   \strong{3. \code{"order_by"}} parameter is a character string that forces sorting of the results. Structure:
    \itemize{
      \item \strong{Structure:} "\code{column_name}:asc|desc"
      \item \strong{Single column example:} "first_seen:asc" ~ this sorts results by \code{first_seen}
      column in ascending order
      \item \strong{Multi column example:} "last_seen:desc,first_seen:asc" ~ this sorts results
          by 1) \code{last_seen} column in descending order, and next by 2) \code{first_seen} column in
          ascending order
    }

    \strong{4. \code{"where"} & \code{"having"}} are \strong{EXPERIMENTAL} parameters of condition sets
        (character strings) that control filtering the results. To create arguments:
        \enumerate{
          \item use \code{rah_condition()} function to create a single condition, for example:
              \code{cond_1 <- rah_condition(column_name = "links", operator = "GREATER_THAN", value = "10")}
          \item use \code{rah_condition_set()} function to group single conditions into final condition
              string, for example: \code{fin_cond <- rah_condition_set(cond_1, cond_2)}
          \item provide final condition to proper report function as a parameter, for example:
              \code{RAhrefs::rah_subscription_info()}
        }
}
\examples{
\dontrun{
# downloading
b <- RAhrefs::rah_subscription_info()
}
}
\seealso{
Other Ahrefs reports: \code{\link{rah_ahrefs_rank}},
  \code{\link{rah_anchors_refdomains}},
  \code{\link{rah_anchors}},
  \code{\link{rah_backlinks_new_lost_counters}},
  \code{\link{rah_backlinks_new_lost}},
  \code{\link{rah_backlinks_one_per_domain}},
  \code{\link{rah_backlinks}},
  \code{\link{rah_broken_backlinks}},
  \code{\link{rah_broken_links}},
  \code{\link{rah_domain_rating}},
  \code{\link{rah_linked_anchors}},
  \code{\link{rah_linked_domains_by_type}},
  \code{\link{rah_linked_domains}},
  \code{\link{rah_metrics_extended}},
  \code{\link{rah_metrics}},
  \code{\link{rah_pages_extended}},
  \code{\link{rah_pages_info}}, \code{\link{rah_pages}},
  \code{\link{rah_refdomains_by_type}},
  \code{\link{rah_refdomains_new_lost_counters}},
  \code{\link{rah_refdomains_new_lost}},
  \code{\link{rah_refdomains}}, \code{\link{rah_refips}}
}
\concept{Ahrefs reports}
