% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_comparison_Power_vs_n.R
\name{power_comparison_Power_vs_n}
\alias{power_comparison_Power_vs_n}
\title{Comparison of Powers for Different Tests under Different DBCD Randomization
Methods (Binary Responses)}
\usage{
power_comparison_Power_vs_n(n_seq, nstart_seq, p, nstop_mat,
replication, group_allo, rho_func_index, rho_func, alpha, sig_level)
}
\arguments{
\item{n_seq}{A sequence of numbers of patients.
The default is c(50, 100, 150, 200).}

\item{nstart_seq}{The burn-in sample size of each arm. If NULL, n_seq/20
will be used.}

\item{p}{A vector of probabilities containing probabilities
for each treatment arm (where the first element refers to the control arm).
The length of p should correspond to the number of treatment arms.
The default is p = c(0.3, 0.3, 0.6).}

\item{nstop_mat}{A matrix of sample size stopping caps for each arm.
Each row corresponds to each n in n_seq, and each column represents each arm.
The trial stops if at least one arm reaches the corresponding cap.
The default is NULL, which means no cap.}

\item{replication}{the number of replications of the simulation. The default
is 100.}

\item{group_allo}{A number or a vector of group size(s) for allocation.
If a number is given, the allocation ratios will be updated for each batch of
 group_allo samples. If a vector is given, the allocation ratios will be
 updated sequentially in group according to the vector.
 The group_allo will be applied to all n (from each n_seq).
 Any value greater than n  will be omitted.
The default is group_allo=1, which is the same as group_allo = seq(nstart*length(p)+1,n).}

\item{rho_func_index}{Supply a number of 1, 2 or 3 indicting the
allocation function to use.
1 = Wei's allocation
2 = Neyman allocation;
3 (default) = Rosenberger allocation.}

\item{rho_func}{Supply a user-specified allocation function of S_RK when
rho_func_index is NULL. Default is NULL.}

\item{alpha}{Supply a number indicating the subscripts of the probability
function. The default is 2.}

\item{sig_level}{Significant level. The default is 0.05.}
}
\value{
\itemize{
  \item Allocation - Average and standard deviation (SD) of allocation distribution
  \item Estimation - Average and standard deviation of the estimators of treatment effect
  \item Power_chisq - Average power of Chi-square test
  \item Power_oneside - Average power of one-sided Welch T-test performed for each of the k-th arm against $H_0: p_1>p_k$ without multiplicity adjustment
  \item Plot - Four figures of results: 1) Allocation mean and SD, 2) Estimated mean response and SD, 3) Power of Chi-square test, 4) Power of one-sided proportion test
}
}
\description{
Compares the power of tests under different sample sizes for the same
treatment effect and design through matrices and plots.
}
\details{
'power_comparison_Power_vs_n' reads different sample sizes as
well as the corresponding burn-in size and outputs allocation, estimated
rates and powers.
}
\examples{

## Default setting
power_comparison_Power_vs_n(
n_seq = seq(from = 50, to = 200, by = 50),
nstart_seq = round(seq(from = 50, to = 200, by = 50) / 20),
p = c(0.3, 0.3, 0.6),
nstop_mat = NULL,
replication = 5,
group_allo = 1,
rho_func_index = 3,
rho_func = NULL,
alpha = 2,
sig_level = 0.05
)


}
