% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.sirius.R
\name{import.sirius}
\alias{import.sirius}
\title{import.sirius}
\usage{
import.sirius(ramclustObj = NULL, ms.dir = NULL, ion.mode = NULL)
}
\arguments{
\item{ramclustObj}{R object - the ramclustR object which was used to write the .mat or .msp files}

\item{ms.dir}{optional path to .mat directory. default = "spectra/ms/out" subdirectory in working directory}

\item{ion.mode}{specify either "N" for negative ionization mode or "P" for positive ionization mode}
}
\value{
an updated ramclustR object, with new slots at $msfinder.sirius
}
\description{
After running Sirius on .ms files, import the annotation results
}
\details{
this function imports the output from the Sirius program to annotate the ramclustR object
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

Broeckling CD, Ganna A, Layer M, Brown K, Sutton B, Ingelsson E, Peers G, Prenni JE. Enabling Efficient and Confident Annotation of LC-MS Metabolomics Data through MS1 Spectrum and Time Prediction. Anal Chem. 2016 Sep 20;88(18):9226-34. doi: 10.1021/acs.analchem.6b02479. Epub 2016 Sep 8. PubMed PMID: 7560453.
}
\author{
Corey Broeckling
}
\concept{RAMClustR}
\concept{annotation}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
