% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clam_ind_RKsolver.R
\name{clam_ind_RKsolver}
\alias{clam_ind_RKsolver}
\title{Solves the Clam individual bioenergetic balance with a 4th order Runge Kutta method}
\usage{
clam_ind_RKsolver(Param, times, IC, Tint, Phyint, DTint, POCint, POMint, TSSint)
}
\arguments{
\item{Param}{a vector containing model parameters}

\item{times}{integration extremes and integration timestep}

\item{IC}{initial condition}

\item{Tint}{the interpolated water temperature time series}

\item{Phyint}{the interpolated phytoplankton time series}

\item{DTint}{the interpolated detritus time series}

\item{POCint}{the interpolated POC time series}

\item{POMint}{the interpolated POM time series}

\item{TSSint}{the interpolated TSS time series}
}
\value{
a list containing the clam weights, temperature limitation functions and metabolic rates
}
\description{
Solves the Clam individual bioenergetic balance with a 4th order Runge Kutta method
}

