% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal.R
\name{counterfactual}
\alias{counterfactual}
\title{Counterfactual inference via simulation}
\usage{
counterfactual(
  scm,
  situation,
  target,
  ifunction,
  n,
  slotsize = 10000,
  maxslots = 100,
  situationSQL = FALSE
)
}
\arguments{
\item{scm}{An SCM object}

\item{situation}{A list or a character string. The list has the following elements:
\itemize{
\item do : NULL or a list containing named elements 'target' and 'ifunction' that
specify the intervention carried out in the situation
\item condition : either a string that gives an SQL query ( "select x,y,z from DATA where" )
or a data.table consisting of the valid rows
}
The character string specifies an SQL query ( "select x,y,z from DATA where" )}

\item{target}{A vector of variable names that specify the target
variable(s) of the counterfactual intervention.}

\item{ifunction}{A list of functions for the counterfactual intervention.}

\item{n}{Size of the data to be simulated}

\item{slotsize}{A scalar, the number of rows to be simulated for a slot}

\item{maxslots}{A scalar, the maximum number of slots}

\item{situationSQL}{Logical, is the situation defined as an SQL query, defaults FALSE}
}
\value{
A data table representing the situation after the counterfactual intervention
}
\description{
Counterfactual inference via simulation
}
\examples{
cfdata <- counterfactual(backdoor,
                         situation = list(do = list(target = "x", ifunction = 0),
                         condition = data.table::data.table( x = 0, y = 0)),
                         target = "x",
                         ifunction = 1,
                         n = 100000)
mean(cfdata$y)
}
