
<!-- README.md is generated from README.Rmd. Please edit that file -->

# R4GoodPersonalFinances <img src="man/figures/logo.png" align="right" height="250" alt="" class="logo-custom-package"/>

<!-- badges: start -->

[!CRAN
status](https://CRAN.R-project.org/package=R4GoodPersonalFinances)
[![metacran
downloads](https://cranlogs.r-pkg.org/badges/R4GoodPersonalFinances)](https://cran.r-project.org/package=R4GoodPersonalFinances)
[![R-CMD-check](https://github.com/R4GoodAcademy/R4GoodPersonalFinances/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/R4GoodAcademy/R4GoodPersonalFinances/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/R4GoodAcademy/R4GoodPersonalFinances/graph/badge.svg)](https://app.codecov.io/gh/R4GoodAcademy/R4GoodPersonalFinances)
[![R4GoodPersonalFinances status
badge](https://r4goodacademy.r-universe.dev/badges/R4GoodPersonalFinances)](https://r4goodacademy.r-universe.dev/R4GoodPersonalFinances)
[![license](https://img.shields.io/github/license/mashape/apistatus.svg)](https://choosealicense.com/licenses/mit/)
[![lifecycle](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html)
<!-- badges: end -->

> *Make Better Financial Decisions*

The `R4GoodPersonalFinances` R package is a set of tools designed to
help you plan and make informed, data-driven decisions for your personal
or household finances.  
These tools are selected carefully to align with academic consensus,
bridging the gap between theoretical knowledge and practical
application. They assist you in:

- finding optimal asset allocation,
- preparing for retirement or financial independence,
- calculating optimal spending,
- and more.

## Installation

### Installation from CRAN

The latest stable version of the package released on CRAN can be
installed with:

``` r
# install.packages("pak")
pak::pak("R4GoodPersonalFinances")
```

### Installation from GitHub

You can install the latest version of R4GoodPersonalFinances from
[GitHub](https://github.com/R4GoodAcademy/R4GoodPersonalFinances) with:

``` r
# install.packages("pak")
pak::pak("R4GoodAcademy/R4GoodPersonalFinances")
```

### Installation from R-universe

You can install the package from
[R-universe](https://r4goodacademy.r-universe.dev/R4GoodPersonalFinances)
also as `WebAssembly` (WASM) binaries for use in WebR applications:

``` r
install.packages(
  "R4GoodPersonalFinances", 
  repos = c(
    "https://r4goodacademy.r-universe.dev", 
    "https://cloud.r-project.org"
  )
)
```

## Acknowledgments

- Haghani V., White J. (2023) *The Missing Billionaires: A Guide to
  Better Financial Decisions*. `ISBN:978-1-119-74791-8`.
- Idzorek, Thomas M., and Paul D. Kaplan. (2024) *Lifetime Financial
  Advice: A Personalized Optimal Multilevel Approach*. CFA Institute
  Research Foundation. `ISBN:978-1-952-92737-9`.
- Milevsky, Moshe. (2020) *Retirement Income Recipes in R: From Ruin
  Probabilities to Intelligent Drawdowns*. Springer.
  `doi.org/10.1007/978-3-030-51434-1`.

## R for Good Academy <img src="man/figures/r4ga-logo.png" align="right" height="200" alt="" class="logo-custom-academy" />

For more information, see
[www.r4good.academy](https://www.r4good.academy/en/blog.html#category=R4GoodPersonalFinances).
The `R4GoodPersonalFinances` R package is part of the *R for Good
Academy* project. You can find there free resources explaining in
details concepts of personal finances implemented in this R package. For
example:

- [How to Determine Our Optimal Asset
  Allocation?](https://www.r4good.academy/en/blog/optimal-asset-allocation/index.en.html#what-do-you-need-to-calculate-your-optimal-asset-allocation)
- See more:
  [www.r4good.academy](https://www.r4good.academy/en/blog.html#category=R4GoodPersonalFinances)

The official package documentation can be found here:  
[r4goodacademy.github.io/R4GoodPersonalFinances](https://r4goodacademy.github.io/R4GoodPersonalFinances/)

> *Make Better Financial Decisions* with the `R4GoodPersonalFinances` R
> package!
