% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sixway.R
\name{sixway}
\alias{sixway}
\title{Draws a sixway plot of MCMC diagnostics.}
\usage{
sixway(chain, name = NULL, acf.maxlag = 100, pacf.maxlag = 10, ...)
}
\arguments{
\item{chain}{A numeric vector, \code{\link{mcmc}} object or \code{\link{mcmc.list}} object
(in which case uses its \code{thin} argument, otherwise assumes thinning = 1), storing the
MCMC chain for a chosen parameter.}

\item{name}{The parameter name. If \code{name = NULL}, the column name of \code{chain} will
be used, unless that is also \code{NULL} in which case 'x' is used.}

\item{acf.maxlag}{Maximum lag at which to calculate the auto-correlation
function. \code{acf.maxlag = 100} by default. See \code{\link[stats]{acf}}.}

\item{pacf.maxlag}{Maximum lag at which to calculate the partial
auto-correlation function. \code{pacf.maxlag = 10} by default. See \code{\link[stats]{pacf}}.}

\item{...}{Other graphical parameters (see \code{\link[graphics]{par}} for
details).}
}
\description{
This function produces a variety of diagnostic plots and statistics for MCMC
chains.
}
\details{
A variety of plots and statistics are displayed in an R graphic
window, including the following:
\itemize{
\item a trace plot of the plotted trajectory of
an MCMC chain for a model parameter;
\item a kernel density plot; kernel density estimates are computed
using \code{\link[stats]{density}};
\item a plotted autocorrelation function (uses \code{\link[stats]{acf}});
\item a plotted partial autocorrelation function (uses \code{\link[stats]{pacf}});
\item a plot of the estimated
Monte Carlo standard error (\code{\link{MCSE}}) of the posterior estimate of the
mean against the number of iterations. As MCMC is a
simulation-based approach this induces (Monte Carlo) uncertainty due to the
random numbers it uses. This uncertainty reduces with more
iterations, and is measured by the MCSE, and so this graph details how long
the chain needs to be run to achieve a specific MCSE;
\item a box contains two contrasting accuracy diagnostics. The
Raftery-Lewis diagnostic (\code{\link[coda]{raftery.diag}}) is a diagnostic
based on a particular quantile of the distribution. The diagnostic Nhat is
used to estimate the length of Markov chain required to estimate a
particular quantile (e.g. the 2.5\% and 97.5\% quantiles) to a given
accuracy. The Brooks-Draper diagnostic (\code{\link{BD}}) is a diagnostic based on
the mean of the distribution. It is used to estimate the length of Markov
chain required to produce a mean estimate to k(=2) significant figures with
a given accuracy;
\item a box of summary
statistics including the posterior mean, sd, mode, quantiles and the
effective sample size (ESS) of the chain.
}
}
\examples{
\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

## Example: tutorial
data(tutorial, package = "R2MLwiN")

(mymodel <- runMLwiN(normexam ~ 1 + standlrt + (1 + standlrt | school) + (1 | student),
                     estoptions = list(EstM = 1, resi.store.levs = 2), data = tutorial))

sixway(mymodel@chains[, "FP_standlrt", drop = FALSE], "beta_1")

}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{BD}},\code{\link{MCSE}},\code{\link{density}},\code{\link{acf}},\code{\link{pacf}},\code{\link[coda]{raftery.diag}},\code{\link[coda]{effectiveSize}}
}

