% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{split_documents}
\alias{split_documents}
\title{split_documents}
\usage{
split_documents(corpus, chunksize, preserveMetadata = TRUE)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{chunksize}{The number of paragraphs each new document should contain at most.}

\item{preserveMetadata}{Whether to preserve the meta-data of original documents.}
}
\value{
A \code{Corpus} object with split documents.
}
\description{
Split documents in a corpus into documents of one of more paragraphs.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
split_documents(corpus, 3)

}
