% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_app_functions.R
\name{updateResistantPopover}
\alias{updateResistantPopover}
\title{Create an update-resistant popover for a Shiny element}
\usage{
updateResistantPopover(
  id,
  title,
  content,
  placement = "bottom",
  trigger = "hover",
  options = NULL
)
}
\arguments{
\item{id}{The id of the Shiny element to which the popover is attached.}

\item{title}{The title of the popover.}

\item{content}{The content of the popover.}

\item{placement}{The placement of the popover relative to the Shiny element (default: "bottom").
Possible values are "top", "bottom", "left", and "right".}

\item{trigger}{The event that triggers the display of the popover (default: "hover").
Possible values are "hover", "focus", and "click".}

\item{options}{A list of additional options for the popover.}
}
\value{
A Shiny HTML tag that contains the JavaScript code for creating the update-resistant popover.
}
\description{
This function creates a popover that is resistant to updates in the associated Shiny element.
It adds an event listener to the specified element, which reinstalls the popover whenever a child
of the element changes.
}
\examples{
\dontrun{
library(shiny)
library(shinyBS)

ui <- shinyUI(fluidPage(
  selectInput("Main2_1","Label","abc",  selectize = TRUE, multiple = TRUE),
  updateResistantPopover("Main2_1", "Label", "content", placement = "right", trigger = "focus"),
  actionButton("destroy", "destroy!")
))

server <- function(input, output, session){
  observeEvent(input$destroy, {
    updateSelectInput(session, "Main2_1", choices="foo")
  })
}

shinyApp(ui, server)
}
}
\author{
K. Rohde (stack overflow)
}
\keyword{internal}
\keyword{shiny_app}
