% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metrics.R
\name{.StatusToMatrix}
\alias{.StatusToMatrix}
\alias{.StatusToArray}
\title{Status vector to matrix}
\usage{
.StatusToMatrix(statusVector)

.StatusToArray(status)
}
\arguments{
\item{statusVector}{Either (i) a named vector of integers, with
names \code{N}, \code{s}, \code{r1}, \code{r2}, either \code{d} or \code{d1} and \code{d2}, and optionally \code{u}; or
(ii) a matrix whose named rows correspond to the same quantities.}

\item{status}{A named three-dimensional array of integers, with slices
named \code{s}, \code{r1}, \code{r2}, either \code{d} or \code{d1} and \code{d2}, and either \code{N} or \code{u}.}
}
\value{
A matrix, containing the input columns plus \code{2d}, representing
either \code{2 * d} or \code{d1 + d2}, and row names.

The row name means that column names are dropped in
the output of \code{DoNotConflict} etc.

A three-dimensional array containing a slice labelled \code{2d},
equivalent to either \code{d + d} or \code{d1 + d2} as appropriate.
}
\description{
Converts a vector to a matrix that can be analysed by the \link{DoNotConflict}
function family.
}
\examples{
  data('sq_trees')

  .StatusToArray(ManyToManyQuartetAgreement(sq_trees[5:7]))
  
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
