% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResolvedQuartets.R
\name{ResolvedQuartets}
\alias{ResolvedQuartets}
\alias{ResolvedTriplets}
\title{Count resolved quartets}
\usage{
ResolvedQuartets(tree, countTriplets = FALSE)

ResolvedTriplets(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{countTriplets}{Logical; if \code{TRUE}, the function will return the number
of triplets instead of the number of quartets.}
}
\value{
A vector of length two, listing the number of quartets (or triplets)
that are [1] resolved; [2] unresolved in the specified tree.
}
\description{
Counts how many quartets are resolved or unresolved in a given tree,
following Brodal \emph{et al.} (2013).
}
\section{Functions}{
\itemize{
\item \code{ResolvedTriplets}: Convenience function to calculate the number of
resolved/unresolved triplets.
}}

\examples{
{
  data(sq_trees)
  
  ResolvedTriplets(sq_trees$collapse_some)
  # Equivalent to:
  ResolvedQuartets(sq_trees$collapse_some, countTriplets=TRUE)
  
  vapply(sq_trees, ResolvedQuartets, integer(2))
}

}
\references{
\insertRef{Brodal2013}{Quartet}
}
\seealso{
Other quartet counting functions: \code{\link{AllQuartets}}
}
\author{
Martin R. Smith
}
\concept{quartet counting functions}
