% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSO.r
\name{QUALYPSO.ANOVA.i}
\alias{QUALYPSO.ANOVA.i}
\title{QUALYPSO.ANOVA.i}
\usage{
QUALYPSO.ANOVA.i(phiStar.i, nMCMC, listScenarioInput)
}
\arguments{
\item{phiStar.i}{vector of \code{nS} climate change response for one lead time or for one grid point: \code{nS x 1}}

\item{nMCMC}{number of MCMC simulation required}

\item{listScenarioInput}{list containing specifications, provided by \code{\link{QUALYPSO.process.scenario}}}
}
\value{
list with the following fields:
\itemize{
  \item \strong{mu}: vector of length \code{nMCMC}, mean climate change response
  \item \strong{sigma2}: vector of length \code{nMCMC}, variance of the residual terms
  \item \strong{effect}: list with \code{nTypeEff} elements, where each element corresponds to a different type of effect (e.g. alpha, beta, gamma in Eq. 7)
  \item \strong{empEff}: list with \code{nTypeEmpEff} elements, where each element corresponds to an empirical effect
  Each element is a matrix \code{nMCMC} x \code{nMaineff}, and \code{nMaineff} is the number of main effects (e.g. number of GCMs, RCMs, etc.)
}
}
\description{
Partition sources of uncertainty in climate change responses for one lead time or one grid point.
}
\references{
Evin, G., B. Hingray, J. Blanchet, N. Eckert, S. Morin, and D. Verfaillie.
Partitioning Uncertainty Components of an Incomplete Ensemble of Climate Projections Using Data Augmentation.
Journal of Climate. \url{https://doi.org/10.1175/JCLI-D-18-0606.1}.
}
\author{
Guillaume Evin
}
