% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdq.band.R
\name{rdq.band}
\alias{rdq.band}
\title{Uniform confidence bands for QTE}
\usage{
rdq.band(y, x, d, x0, z0 = NULL, tau, bdw, cov, alpha)
}
\arguments{
\item{y}{a numeric vector, the outcome variable.}

\item{x}{a vector (or a matrix) of covariates, the first column is the running variable.}

\item{d}{a numeric vector, the treatment status.}

\item{x0}{the cutoff point.}

\item{z0}{the value of the covariates at which to evaluate the effects.
For example, if a female dummy is included, z0 = 1 may indicate the female subgroup.}

\item{tau}{a vector of quantiles of interest.}

\item{bdw}{the bandwidth value(s). If 'bdw' is a scalar, it is interpreted as the
bandwidth for the median. The bandwidths for the rest of the quantiles are
computed automatically using the formula in Yu and Jones (1998).
If it is a vector with the same dimension as 'tau',
the function will use these values for the respective quantiles accordingly.}

\item{cov}{either 0 or 1. Set cov=1 when covariates are present in the model;
otherwise set cov=0.}

\item{alpha}{a number between 0 and 1, the desired significance level.}
}
\value{
\describe{
\item{qte}{QTE estimates without bias correction.}
\item{qte.cor}{bias corrected QTE estimates.}
\item{uband}{uniform confidence band for QTE without bias correction.}
\item{uband.robust}{uniform confidence band for QTE with robust bias correction.}
\item{sig}{standard errors for each quantile level for estimates without bias correction.}
\item{sig.r}{standard errors for each quantile level for estimates with robust bias correction.}
\item{uband.p}{uniform confidence band for the conditional quantile estimates on the right side of the cutoff, without bias correction.}
\item{uband.robust.p}{uniform confidence band for the conditional quantile estimates on the right side of the cutoff, robust to the bias correction.}
\item{uband.m}{uniform confidence band for the conditional quantile estimates on the left side of the cutoff, without bias correction.}
\item{uband.robust.m}{uniform confidence band for the conditional quantile estimates on the left side of the cutoff, robust to the bias correction.}
}
}
\description{
\code{rdq.band} produces uniform confidence bands for QTEs with and without bias correction. This function is used by \code{rd.qte} to generate uniform bands.
}
\examples{
# Without covariate
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
D = rdq.band(y=y,x=x,d=d,x0=0,z0=NULL,tau=tlevel,bdw=2,cov=0,alpha=0.1)

# (continued) With covariates
z = sample(c(0,1),n,replace=TRUE)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + d*z + rnorm(n)
\donttest{D = rdq.band(y=y,x=cbind(x,z),d=d,x0=0,z0=c(0,1),tau=tlevel,bdw=2,cov=1,alpha=0.1)}

}
\references{
Zhongjun Qu, Jungmo Yoon, Pierre Perron (2024), "Inference on Conditional Quantile
Processes in Partially Linear Models with Applications to the Impact of Unemployment Benefits,"
The Review of Economics and Statistics; https://doi.org/10.1162/rest_a_01168

Zhongjun Qu and Jungmo Yoon (2019), "Uniform Inference on Quantile Effects
under Sharp Regression Discontinuity Designs," Journal of Business and Economic Statistics,
37(4), 625–647; https://doi.org/10.1080/07350015.2017.1407323

Keming Yu and M. C. Jones (1998), “Local Linear Quantile Regression,”
Journal of the American Statistical Association, 93(441), 228–237; https://doi.org/10.2307/2669619
}
\seealso{
\link{rd.qte}
}
