% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VecDecomVec.R
\name{VecDecomVec}
\alias{VecDecomVec}
\title{Vector decomposition and remainder fields}
\usage{
VecDecomVec(x.num.steps, y.num.steps, x.rhs, y.rhs, x.bound, y.bound)
}
\arguments{
\item{x.num.steps}{the number of steps between the minimum and maximum x value defined in x range.}

\item{y.num.steps}{the number of steps between the minimum and maximum y value defined in y range.}

\item{x.rhs}{a string containing the right hand side of the equation for x.}

\item{y.rhs}{a string containing the right hand side of the equation for y.}

\item{x.bound}{the x boundaries denoted at c(minimum, maximum).}

\item{y.bound}{the y boundaries denoted at c(minimum, maximum).}
}
\value{
returns an array of the deterministic skeleton vector field.  The array has three dimensions with the respective lengths of x.num.steps, y.num.steps, and the number of variables (always 2).  The two variables are the x-deterministic skeleton and the y-deterministic skeleton.
}
\description{
This function calculates the vector field.
}
\examples{
# First, the system of equations
	equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0+x*x)"
	equationy <- "((0.476*x*x*y)/(1+x*x)) - 0.112590*y*y"

# Second, shared parameters for each quasi-potential run
	xbounds <- c(-0.5, 20.0)
	ybounds <- c(-0.5, 20.0)
	xstepnumber <- 1000
	ystepnumber <- 1000

# Third, create the deterministic skeleton vector field
	VDV <- VecDecomVec(x.num.steps = xstepnumber, y.num.steps = ystepnumber, x.rhs = equationx, 
	y.rhs = equationy, x.bound = xbounds, y.bound = ybounds)
}

